<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function ($) {
    // Debug: Log all checkboxes found
    console.log('All checkboxes found:', $('.frm_checkbox').length);
    
    // Define tooltip content for each checkbox by ID
    var tooltipContentMap = {
        "field_3nn3p2-0": `
            <b>Requirements</b><br>
            To integrate with ChatGPT, you will need:
            <ul>
                <li>An active OpenAI account.</li>
                <li>A valid subscription to the required OpenAI plan.</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
        "field_3nn3p-17": `
            <b>Requirements</b><br>
            To integrate with HubSpot you will need:
            <ul>
                <li>Access to App ID</li>
                <li>Access to Client ID</li>
                <li>Access to Client Secret</li>
            </ul>
            <b>Setup</b>
            <ul>
                <li>Enter required credentials using Enwage</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
        "field_3nn3p-1": `
            <b>Requirements</b><br>
            To integrate with Outlook you will need:
            <ul>
                <li>An existing Microsoft account</li>
            </ul>
            <b>Setup</b>
            <ul>
                <li>Log in to your Microsoft account</li>
                <li>Enter credentials using Enwage.</li>
                <li>Use Outlook for communication using Inbox within Enwage</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
        "field_3nn3p-15": `
            <b>Requirements</b><br>
            To integrate with Outlook you will need:
            <ul>
                <li>An existing Microsoft account</li>
            </ul>
            <b>Setup</b>
            <ul>
                <li>Log in to your Microsoft account</li>
                <li>Enter credentials using Enwage.</li>
                <li>Use Outlook for communication using Inbox within Enwage</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
		 "field_3nn3p-23": `
            <b>Requirements</b><br>
            To integrate with QuickBooks Online you will need:
            <ul>
                <li>An active QuickBooks Online subscription on the Essentials plan or higher.</li>
				<li>A QuickBooks Online subscription in the UK, US, Canada or Australia.</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
		"field_3nn3p-25": `
            <b>Requirements</b><br>
            To integrate with QuickBooks Online you will need:
            <ul>
                <li>An active QuickBooks Online subscription on the Essentials plan or higher.</li>
				<li>A QuickBooks Online subscription in the UK, US, Canada or Australia.</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
		"field_3nn3p-26": `
            <b>Requirements</b><br>
            To integrate with QuickBooks Online you will need:
            <ul>
                <li>An active QuickBooks Online subscription on the Essentials plan or higher.</li>
				<li>A QuickBooks Online subscription in the UK, US, Canada or Australia.</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
		"field_3nn3p-27": `
            <b>Requirements</b><br>
            To integrate with Twilio you will need:
            <ul>
                <li>An active Twilio subscription</li>
				<li>An active Twilio number</li>
				<li>SID and Auth Token provided by Twilio</li>
            </ul>
			<b>Setup</b>
                <li>Enter Required credentials using Enwage</li>
				<li>Use Twilio SMS for candidate and employee messaging feature with Twilio</li>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `,
		"field_3nn3p-28": `
            <b>Requirements</b><br>
            To integrate with DISA you will need:
            <ul>
                <li>Access to Credential 1.</li>
				<li>Access to Credential 2.</li>
				<li>Access to Secret.</li>
            </ul>
			<b>Setup</b><br>
            <ul>
                <li>Enter Required credentials using Enwage</li>
				<li>Use DISA for screening of candidates and employees</li>
            </ul>
            <p>For more information, the Onboarding Team will reach out to you.</p>
        `
        // Add other specific mappings as needed
    };

    // Remove any existing tooltips
    $('.custom-tooltip').remove();

    // Iterate through all checkboxes and add tooltips dynamically
    $(".frm_checkbox").each(function () {
        var checkbox = $(this).find("input[type='checkbox']");
        var checkboxId = checkbox.attr("id");
        
        // Debug: Log each checkbox ID found
        console.log('Processing checkbox ID:', checkboxId);

        var tooltipContent = tooltipContentMap[checkboxId];
        
        // Debug: Log whether content was found for this ID
        console.log('Content found for ID', checkboxId + ':', !!tooltipContent);

        if (tooltipContent) {
            // Create a tooltip container with a unique ID
            var tooltipId = 'tooltip-' + checkboxId;
            var tooltip = $('<div></div>')
                .addClass('custom-tooltip')
                .attr('id', tooltipId)
                .html(tooltipContent);

            // Add position relative to parent
            $(this).css('position', 'relative');
            
            // Remove any existing tooltip before adding new one
            $('#' + tooltipId).remove();
            
            // Append tooltip
            $(this).append(tooltip);

            // Show tooltip on hover
            $(this).hover(
                function (e) {
                    $('.custom-tooltip').hide(); // Hide all other tooltips
                    $('#' + tooltipId)
                        .css({
                            top: '100%',
                            left: '50%',
                            transform: 'translateX(-50%)',
                            display: 'block'
                        })
                        .fadeIn(200);
                },
                function (e) {
                    $('#' + tooltipId).fadeOut(200);
                }
            );
        }
    });

    // Add styling for the tooltip
    $("<style>")
        .prop("type", "text/css")
        .html(`
            .frm_checkbox {
                position: relative;
            }
            
            .custom-tooltip {
                position: absolute;
                display: none;
                background-color: #f1f1f1;
                color: #000;
                padding: 10px;
                border-radius: 8px;
                font-size: 12px;
                z-index: 9999;
                white-space: normal;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
                text-align: left;
                width: 280px;
                line-height: 1.4;
                word-wrap: break-word;
                margin-top: 5px;
            }

            .custom-tooltip::before {
                content: '';
                position: absolute;
                top: -8px;
                left: 50%;
                transform: translateX(-50%);
                border-width: 0 8px 8px 8px;
                border-style: solid;
                border-color: transparent transparent #f1f1f1 transparent;
            }

            .custom-tooltip ul {
                padding-left: 20px;
                margin: 10px 0;
            }

            .custom-tooltip ul li {
                margin-bottom: 5px;
            }

            .custom-tooltip b {
                color: #000;
                font-weight: 700;
            }
        `)
        .appendTo("head");
});</script>
<!-- end Simple Custom CSS and JS -->
