<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function ($) {
    // Debug: Log all checkboxes found
    console.log('All checkboxes found:', $('.frm_checkbox').length);
    
    // Define shared content
    const chatGPTContent = `
<b>Usage</b>
<ul>
<li>Text/Verbiage creation using AI Prompts.</li>
</ul>
        <b>Requirements</b><br>
        To integrate with ChatGPT, you will need:
        <ul>
            <li>An active OpenAI account.</li>
            <li>A valid subscription to the required OpenAI plan.</li>
        </ul>
<b>Features</b>
<ul>
<li>Job description creation in candidate’s module.</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;

    const outlookContent = `
<b>Usage</b>
<ul>
<li>Emailing</li>
</ul>
        <b>Requirements</b><br>
        To integrate with Outlook you will need:
        <ul>
            <li>An existing Microsoft account</li>
        </ul>
        <b>Setup</b>
        <ul>
            <li>Log in to your Microsoft account</li>
            <li>Enter credentials using Enwage.</li>
            <li>Use Outlook for communication using Inbox within Enwage</li>
        </ul>
<b>Features</b>
<ul>
<li>Can send emails to employees and candidates</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;

    const hubspotContent = `
<b>Usage</b>
<ul><li>CRM</li></ul>        
<b>Requirements</b><br>
        To integrate with HubSpot you will need:
        <ul>
            <li>Access to App ID</li>
            <li>Access to Client ID</li>
            <li>Access to Client Secret</li>
        </ul>
        <b>Setup</b>
        <ul>
            <li>Enter required credentials using Enwage</li>
        </ul>
<b>Feature</b>
<ul>
<li>Import of Clients and their contacts from HubSpot upon deal done stage in HubSpot.</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;

    const quickbooksContent = `
<b>Usage</b>
<ul>
<li>Accounting</li>
</ul>
        <b>Requirements</b><br>
        To integrate with QuickBooks Online you will need:
        <ul>
            <li>An active QuickBooks Online subscription on the Essentials plan or higher.</li>
            <li>A QuickBooks Online subscription in the UK, US, Canada or Australia.</li>
        </ul>
<b>Feature</b>
<ul>
<li>Establish connection between QuickBooks and Enwage Clients and create Invoices from Enwage to QuickBooks for accounting purposes.</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>

    `;

    const twilioContent = `
<b>Usage</b>
<ul>
<li>SMS</li>
</ul>
        <b>Requirements</b><br>
        To integrate with Twilio you will need:
        <ul>
            <li>An active Twilio subscription</li>
            <li>An active Twilio number</li>
            <li>SID and Auth Token provided by Twilio</li>
        </ul>
        <b>Setup</b>
<ul>
        <li>Enter Required credentials using Enwage</li>
        <li>Use Twilio SMS for candidate and employee messaging feature with Twilio</li>
</ul>
<b>Feature</b>
<ul>
<li>Can send SMS to employees and candidates</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;

    const googleJobs = `
<b>Usage</b>
<ul>
<li>To Publish jobs and get candidates in ATS.</li>
</ul>
        <b>Requirements</b><br>
        To integrate with Google for Jobs you will need:
        <ul>
            <li>Access to API Key</li>
        </ul>
        <b>Setup</b><br>
        <ul>
            <li>Log In to your google cloud console account</li>
            <li>Create service account</li>
            <li>Download the provided API key</li>
        </ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;
	
	    const disaContent = `
<b>Usage</b>
<ul>
<li>DISA</li>
</ul>
        <b>Requirements</b><br>
        To integrate with DISA you will need:
        <ul>
            <li>Access to Credential 1.</li>
            <li>Access to Credential 2.</li>
            <li>Access to Secret.</li>
        </ul>
        <b>Setup</b><br>
        <ul>
            <li>Enter Required credentials using Enwage</li>
            <li>Use DISA for screening of candidates and employees</li>
        </ul>
<b>Feature</b>
<ul>
<li>Screening/background check requests can be sent from the Enwage and can have the results in Enwage for employees and candidates.</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;
	    const soveRn = `
<b>Usage</b>
<ul>
<li>Resume Parser</li>
</ul>
        <b>Requirements</b><br>
        To integrate with Sovren you will need:
        <ul>
            <li>Access to Account ID</li>
            <li>Access to Service Key</li>
        </ul>
        <b>Setup</b><br>
        <ul>
            <li>Enter required credentials using Enwage</li>
            <li>Use Sovren for resume parsing of candidates</li>
        </ul>
<b>Feature</b>
<ul>
<li>During Candidates addition you can add a candidate through parsing his/her resume.</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;
	
	const striPe=`
<b>Usage</b>
<ul>
<li>Payment Gateway </li>
</ul>
        <b>Requirements</b><br>
        To integrate with Stripe, you will need:
        <ul>
            <li>Access to Publishable Token</li>
            <li>Access to Secret Token</li>
        </ul>
<b>Feature</b>
<ul>
<li>Online payment functionality.</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
`;
		const masterTax=`
<b>Master Tax</b>
<ul>
<li> Payroll Tax Filing Software</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
`;
	    const monsterJob = `
<b>Usage</b>
<ul>
<li>Job Posting</li>
</ul>
        <b>Requirements</b><br>
        To integrate with Monster (Free Posting) Online you will need:
        <ul>
            <li>An active Monster (Free Posting) subscription.</li>
            <li>A Monster (Free Posting) subscription in the UK, US, Canada or Australia</li>
        </ul>
        <b>Setup</b><br>
        <ul>
            <li>Enter required credentials using Enwage</li>
            <li>Use Monster (Free Posting) for job posting needs</li>
        </ul>
<b>Features</b>
<ul>
<li>Use for Job Posting</li>
</ul>
        <p>For more information, the Onboarding Team will reach out to you.</p>
    `;
    // Map IDs to content
    var tooltipContentMap = {
        // ChatGPT integrations
        "field_3nn3p-20": chatGPTContent,
        "field_3nn3p2-0": chatGPTContent,
		"field_3nn3p3-0": chatGPTContent,
        
        // Outlook integrations
        "field_3nn3p-1": outlookContent,
        "field_3nn3p2-5": outlookContent,
		"field_3nn3p3-5": outlookContent,
		"field_3nn3p-15": outlookContent,
        
        // HubSpot integration
        "field_3nn3p-17": hubspotContent,
		"field_3nn3p2-2": hubspotContent,
		"field_3nn3p3-2": hubspotContent,
        
        // QuickBooks integrations
        "field_3nn3p-23": quickbooksContent,
        "field_3nn3p2-6": quickbooksContent,
        "field_3nn3p3-6": quickbooksContent,
		
        // Twilio integration
        "field_3nn3p-27": twilioContent,
		"field_3nn3p2-10": twilioContent,
        "field_3nn3p3-10": twilioContent,
		
        // DISA integration
        "field_3nn3p-28": disaContent,
		"field_3nn3p2-11": disaContent,
		"field_3nn3p3-11": disaContent,
		
		// Google for jobs integration
        "field_3nn3p2-1": googleJobs,
		"field_3nn3p3-1": googleJobs,
		
		// Sovern integration
        "field_3nn3p2-7": soveRn,
		"field_3nn3p3-7": soveRn,
		
		
		//Stripe integration
		"field_3nn3p2-8": striPe,
		"field_3nn3p-25": striPe,
		"field_3nn3p3-8": striPe,
		
		//MasterTax integration
		"field_3nn3p-1": masterTax,
		"field_3nn3p-1": masterTax,
		
		//Monster integration
		"field_3nn3p2-4": monsterJob,
		"field_3nn3p3-4": monsterJob,
    };

    // Remove any existing tooltips
    $('.custom-tooltip').remove();

    // Iterate through all checkboxes and add tooltips dynamically
    $(".frm_checkbox").each(function () {
        var checkbox = $(this).find("input[type='checkbox']");
        var checkboxId = checkbox.attr("id");
        
        // Debug: Log each checkbox ID found
        console.log('Processing checkbox ID:', checkboxId);

        var tooltipContent = tooltipContentMap[checkboxId];
        
        // Debug: Log whether content was found for this ID
        console.log('Content found for ID', checkboxId + ':', !!tooltipContent);

        if (tooltipContent) {
            // Create a tooltip container with a unique ID
            var tooltipId = 'tooltip-' + checkboxId;
            var tooltip = $('<div></div>')
                .addClass('custom-tooltip')
                .attr('id', tooltipId)
                .html(tooltipContent);

            // Add position relative to parent
            $(this).css('position', 'relative');
            
            // Remove any existing tooltip before adding new one
            $('#' + tooltipId).remove();
            
            // Append tooltip
            $(this).append(tooltip);

            // Show tooltip on hover
            $(this).hover(
                function (e) {
                    $('.custom-tooltip').hide(); // Hide all other tooltips
                    $('#' + tooltipId)
                        .css({
                            top: '100%',
                            left: '50%',
                            transform: 'translateX(-50%)',
                            display: 'block'
                        })
                        .fadeIn(200);
                },
                function (e) {
                    $('#' + tooltipId).fadeOut(200);
                }
            );
        }
    });

    // Add styling for the tooltip
    $("<style>")
        .prop("type", "text/css")
        .html(`
            .frm_checkbox {
                position: relative;
            }
            
            .custom-tooltip {
                position: absolute;
                display: none;
                background-color: #f1f1f1;
                color: #000;
                padding: 10px;
                border-radius: 8px;
                font-size: 12px;
                z-index: 9999;
                white-space: normal;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
                text-align: left;
                width: 280px;
                line-height: 1.4;
                word-wrap: break-word;
                margin-top: 5px;
            }

            .custom-tooltip::before {
                content: '';
                position: absolute;
                top: -8px;
                left: 50%;
                transform: translateX(-50%);
                border-width: 0 8px 8px 8px;
                border-style: solid;
                border-color: transparent transparent #f1f1f1 transparent;
            }

            .custom-tooltip ul {
                padding-left: 20px;
                margin: 10px 0;
            }

            .custom-tooltip ul li {
                margin-bottom: 5px;
            }

            .custom-tooltip b {
                color: #000;
                font-weight: 700;
            }
        `)
        .appendTo("head");
});</script>
<!-- end Simple Custom CSS and JS -->
