<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function () {
    // Select the target radio button label
    const standardLabel = document.querySelector('#frm_radio_1415-0 label');

    if (standardLabel) {
        // Remove existing text from the label
        standardLabel.childNodes.forEach((node) => {
            if (node.nodeType === Node.TEXT_NODE) {
                node.textContent = ''; // Clear duplicate text
            }
        });

        // Create a wrapper for the tooltip
        const tooltipWrapper = document.createElement('span');
        tooltipWrapper.className = 'tooltip-target';
        tooltipWrapper.textContent = 'Standard ';

        // Add the Font Awesome info icon
        const infoIcon = document.createElement('i');
        infoIcon.className = 'fas fa-info-circle info-icon'; // Font Awesome icon
        tooltipWrapper.appendChild(infoIcon);

        // Create the tooltip content with a minimal styled list
        const tooltipContent = document.createElement('div');
        tooltipContent.className = 'tooltip-content';

        tooltipContent.innerHTML = `
            <ul class="benefit-list">
                <li>Tax liability Detail journal</li>
                <li>Tax liability</li>
                <li>W3 totals</li>
            </ul>
        `;

        // Append the tooltip to the label
        tooltipWrapper.appendChild(tooltipContent);
        standardLabel.appendChild(tooltipWrapper);

        // Ensure the tooltip stays in view
        tooltipWrapper.addEventListener('mouseenter', function () {
            const tooltipRect = tooltipContent.getBoundingClientRect();
            if (tooltipRect.right > window.innerWidth) {
                tooltipContent.style.left = 'auto';
                tooltipContent.style.right = '100%';
            }
        });
    }
});
</script>
<!-- end Simple Custom CSS and JS -->
