<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function () {
    // Select the "Standard" radio field container
    const standardRadio = document.querySelector("#frm_radio_1299-0 label");

    if (standardRadio) {
        // Create the info icon element
        const infoIcon = document.createElement("span");
        infoIcon.className = "info-icon";
        infoIcon.setAttribute("tabindex", "0");
        infoIcon.textContent = "ⓘ";

        // Create the tooltip content
        const tooltipContent = `
            <table class="custom-tooltip-table">
                <thead>
                    <tr>
                        <th>Module</th>
                        <th>Report Name</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td rowspan="5">Clients</td>
                        <td>Client Master general info</td>
                    </tr>
                    <tr><td>Client contacts</td></tr>
                    <tr><td>Client profitability analysis</td></tr>
                    <tr><td>Client commission</td></tr>
                    <tr><td>Client Master billing</td></tr>
                    <tr>
                        <td rowspan="13">Employees</td>
                        <td>Turn-over ratio</td>
                    </tr>
                    <tr><td>Employee general information</td></tr>
                    <tr><td>Employee earning</td></tr>
                    <tr><td>Employee PTO Accrual</td></tr>
                    <tr><td>Employee Check Acknowledgement</td></tr>
                    <tr><td>Employee census</td></tr>
                    <tr><td>Employee onboarding</td></tr>
                    <tr><td>Employee direct deposit</td></tr>
                    <tr><td>New Hire</td></tr>
                    <tr><td>Employee termination</td></tr>
                    <tr><td>Employee export</td></tr>
                </tbody>
            </table>
        `;

        // Create the tooltip wrapper
        const tooltipWrapper = document.createElement("div");
        tooltipWrapper.className = "tooltip-wrapper";
        tooltipWrapper.innerHTML = tooltipContent;

        // Append the tooltip wrapper to the info icon
        infoIcon.appendChild(tooltipWrapper);

        // Append the info icon after the "Standard" label
        standardRadio.appendChild(infoIcon);

        // Add CSS styles for the tooltip
        const style = document.createElement("style");
        style.innerHTML = `
            .info-icon {
                display: inline-block;
                margin-left: 5px;
                font-size: 14px;
                color: #007bff;
                cursor: pointer;
                position: relative;
            }
            .tooltip-wrapper {
                display: none;
                position: absolute;
                top: 25px;
                left: 0;
                background: #fff;
                border: 1px solid #ccc;
                box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
                padding: 10px;
                z-index: 1000;
                max-width: 300px;
                font-size: 12px;
            }
            .tooltip-wrapper table {
                width: 100%;
                border-collapse: collapse;
            }
            .tooltip-wrapper th,
            .tooltip-wrapper td {
                border: 1px solid #ddd;
                padding: 5px;
                text-align: left;
            }
            .tooltip-wrapper th {
                background-color: #f4f4f4;
            }
            .info-icon:hover .tooltip-wrapper,
            .info-icon:focus .tooltip-wrapper {
                display: block;
            }
        `;
        document.head.appendChild(style);
    }
});
</script>
<!-- end Simple Custom CSS and JS -->
