<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
// // Add this to your existing script, ideally just before the DOMContentLoaded event listener

// // Function to calculate form progress for specific fields in form 119
// function calculateBenefitsFormProgress() {
//     const formId = '119';
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form) return 0;
    
//     // Replace these IDs with your actual form field IDs for the Benefits form
//     // These should be the specific fields you want to track for progress
//     const specificFieldIds = [
//         'field_5upd54',     // Replace with actual health benefits field ID
//         'field_snsot4', // Replace with actual retirement field ID
//         'field_joyoa4'
//     ];
    
//     // Track number of filled fields
//     let filledFields = 0;
//     let totalFields = 0;
    
//     specificFieldIds.forEach(id => {
//         const field = form.querySelector(`#${id}`);
//         if (field) {
//             totalFields++;
            
//             if (field.type === 'checkbox' || field.type === 'radio') {
//                 if (field.checked) filledFields++;
//             } else {
//                 if (field.value && field.value.trim() !== '') filledFields++;
//             }
//         }
//     });
    
//     // Calculate progress percentage
//     const progress = totalFields > 0 ? Math.round((filledFields / totalFields) * 100) : 0;
    
//     // Update localStorage and UI
//     localStorage.setItem(`form_${formId}_progress`, progress);
    
//     const progressText = document.querySelector(`#progress-${formId}`);
//     if (progressText) {
//         progressText.textContent = `${progress}%`;
//     }
    
//     // Update button state
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (actionButton) {
//         if (progress >= 100) {
//             actionButton.classList.remove('start-button', 'resume');
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//             localStorage.setItem(`form_${formId}_completed`, 'true');
//         } else if (progress > 0) {
//             actionButton.classList.remove('start-button', 'completed');
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//         }
//     }
    
//     return progress;
// }

// // Add this to your existing monitorFormInputs function
// function monitorBenefitsForm() {
//     // Monitor all input changes for the Benefits form specifically
//     document.addEventListener('input', function(event) {
//         const formContainer = event.target.closest('[id^="frm_form_119_"]');
//         if (formContainer) {
//             calculateBenefitsFormProgress();
//         }
//     });
    
//     document.addEventListener('change', function(event) {
//         const formContainer = event.target.closest('[id^="frm_form_119_"]');
//         if (formContainer) {
//             calculateBenefitsFormProgress();
//         }
//     });
// }

// // Add this to your DOMContentLoaded event handler
// document.addEventListener('DOMContentLoaded', function() {
//     // Initialize existing progress if any
//     const progress = localStorage.getItem('form_119_progress') || 0;
//     const isCompleted = localStorage.getItem('form_119_completed') === 'true';
    
//     const progressText = document.querySelector('#progress-119');
//     if (progressText) {
//         progressText.textContent = `${progress}%`;
//     }
    
//     const actionButton = document.querySelector('.card[data-form-id="119"] .action-button');
//     if (actionButton) {
//         if (isCompleted) {
//             actionButton.classList.remove('start-button', 'resume');
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//         } else if (progress > 0) {
//             actionButton.classList.remove('start-button', 'completed');
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//         }
//     }
    
//     // Set up event listener for the Benefits form button
//     const benefitsButton = document.querySelector('.card[data-form-id="119"] .action-button');
//     if (benefitsButton) {
//         benefitsButton.addEventListener('click', function() {
//             const tabId = this.getAttribute('data-tab');
//             localStorage.setItem('form_119_last_active', Date.now());
            
//             // Find and click the tab
//             const menuItem = document.querySelector(`.menu-item[data-tab="${tabId}"]`);
//             if (menuItem) menuItem.click();
//         });
//     }
    
//     // Monitor the Benefits form inputs
//     monitorBenefitsForm();
// });




















// // Function to calculate form progress for specific fields in form 119
// function calculateBenefitsFormProgress() {
//     const formId = '119';
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form) return 0;
    
//     // Specific fields to track for progress
//     const specificFieldIds = [
//         'field_5upd54',
//         'field_snsot4',
//         'field_joyoa4'
//     ];
    
//     // Track number of filled fields
//     let filledFields = 0;
//     let totalFields = 0;
    
//     specificFieldIds.forEach(id => {
//         const field = form.querySelector(`#${id}`);
//         if (field) {
//             totalFields++;
            
//             if (field.type === 'checkbox' || field.type === 'radio') {
//                 if (field.checked) filledFields++;
//             } else {
//                 if (field.value && field.value.trim() !== '') filledFields++;
//             }
//         }
//     });
    
//     // Calculate progress percentage
//     const progress = totalFields > 0 ? Math.round((filledFields / totalFields) * 100) : 0;
    
//     // Update localStorage and UI
//     localStorage.setItem(`form_${formId}_progress`, progress);
    
//     const progressText = document.querySelector(`#progress-${formId}`);
//     if (progressText) {
//         progressText.textContent = `${progress}%`;
//     }
    
//     // Update button state
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (actionButton) {
//         if (progress >= 100) {
//             actionButton.classList.remove('start-button', 'resume');
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//             localStorage.setItem(`form_${formId}_completed`, 'true');
//         } else if (progress > 0) {
//             actionButton.classList.remove('start-button', 'completed');
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//             // Important: Make sure to reset completed status if progress is not 100%
//             localStorage.setItem(`form_${formId}_completed`, 'false');
//         } else {
//             // Reset to start button if no progress
//             actionButton.classList.remove('resume', 'completed');
//             actionButton.classList.add('start-button');
//             actionButton.innerHTML = '<i class="fas fa-arrow-right arrow-icon"></i> Start Now';
//             actionButton.disabled = false;
//             localStorage.setItem(`form_${formId}_completed`, 'false');
//         }
//     }
    
//     return progress;
// }

// // Monitor all input changes for the Benefits form specifically
// function monitorBenefitsForm() {
//     document.addEventListener('input', function(event) {
//         const formContainer = event.target.closest('[id^="frm_form_119_"]');
//         if (formContainer) {
//             calculateBenefitsFormProgress();
//         }
//     });
    
//     document.addEventListener('change', function(event) {
//         const formContainer = event.target.closest('[id^="frm_form_119_"]');
//         if (formContainer) {
//             calculateBenefitsFormProgress();
//         }
//     });
// }

// // Add this function to verify actual form completion on page load
// function verifyFormCompletion() {
//     const formId = '119';
//     const storedProgress = parseInt(localStorage.getItem(`form_${formId}_progress`) || '0');
//     const storedCompletion = localStorage.getItem(`form_${formId}_completed`) === 'true';
    
//     // If the form is marked as completed but doesn't have 100% progress, fix it
//     if (storedCompletion && storedProgress < 100) {
//         // Calculate actual progress based on current field values
//         const actualProgress = calculateBenefitsFormProgress();
        
//         // If actual progress is not 100%, mark as not completed
//         if (actualProgress < 100) {
//             localStorage.setItem(`form_${formId}_completed`, 'false');
            
//             // Update button state
//             const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//             if (actionButton) {
//                 if (actualProgress > 0) {
//                     actionButton.classList.remove('start-button', 'completed');
//                     actionButton.classList.add('resume');
//                     actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//                     actionButton.disabled = false;
//                 } else {
//                     actionButton.classList.remove('resume', 'completed');
//                     actionButton.classList.add('start-button');
//                     actionButton.innerHTML = '<i class="fas fa-arrow-right arrow-icon"></i> Start Now';
//                     actionButton.disabled = false;
//                 }
//             }
//         }
//     }
// }

// // Add this to your DOMContentLoaded event handler
// document.addEventListener('DOMContentLoaded', function() {
//     // Initialize existing progress if any
//     const progress = parseInt(localStorage.getItem('form_119_progress') || '0');
//     const isCompleted = localStorage.getItem('form_119_completed') === 'true';
    
//     const progressText = document.querySelector('#progress-119');
//     if (progressText) {
//         progressText.textContent = `${progress}%`;
//     }
    
//     const actionButton = document.querySelector('.card[data-form-id="119"] .action-button');
//     if (actionButton) {
//         if (isCompleted && progress === 100) {
//             actionButton.classList.remove('start-button', 'resume');
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//         } else if (progress > 0) {
//             actionButton.classList.remove('start-button', 'completed');
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//             // Ensure completion status is correct
//             if (isCompleted && progress < 100) {
//                 localStorage.setItem('form_119_completed', 'false');
//             }
//         } else {
//             actionButton.classList.remove('resume', 'completed');
//             actionButton.classList.add('start-button');
//             actionButton.innerHTML = '<i class="fas fa-arrow-right arrow-icon"></i> Start Now';
//             actionButton.disabled = false;
//             // Ensure completion status is correct for zero progress
//             localStorage.setItem('form_119_completed', 'false');
//         }
//     }
    
//     // Set up event listener for the Benefits form button
//     const benefitsButton = document.querySelector('.card[data-form-id="119"] .action-button');
//     if (benefitsButton) {
//         benefitsButton.addEventListener('click', function() {
//             const tabId = this.getAttribute('data-tab');
//             localStorage.setItem('form_119_last_active', Date.now());
            
//             // Find and click the tab
//             const menuItem = document.querySelector(`.menu-item[data-tab="${tabId}"]`);
//             if (menuItem) menuItem.click();
//         });
//     }
    
//     // Monitor the Benefits form inputs
//     monitorBenefitsForm();
    
//     // Verify form completion status on page load
//     setTimeout(verifyFormCompletion, 500); // Short delay to ensure form is fully loaded
// });













// // Generic form progress calculator that works with any form ID
// function calculateFormProgress(formId, fieldIds) {
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form) return 0;
    
//     // Track number of filled fields
//     let filledFields = 0;
//     let totalFields = 0;
    
//     fieldIds.forEach(id => {
//         const field = form.querySelector(`#${id}`);
//         if (field) {
//             totalFields++;
            
//             if (field.type === 'checkbox' || field.type === 'radio') {
//                 // For radio buttons, check if any in the same name group is selected
//                 if (field.type === 'radio') {
//                     const radioGroup = document.querySelectorAll(`input[name="${field.name}"]:checked`);
//                     if (radioGroup.length > 0) filledFields++;
//                 } else if (field.checked) {
//                     filledFields++;
//                 }
//             } else {
//                 if (field.value && field.value.trim() !== '') filledFields++;
//             }
//         }
//     });
    
//     // Calculate progress percentage
//     const progress = totalFields > 0 ? Math.round((filledFields / totalFields) * 100) : 0;
    
//     // Update localStorage and UI
//     localStorage.setItem(`form_${formId}_progress`, progress);
    
//     const progressText = document.querySelector(`#progress-${formId}`);
//     if (progressText) {
//         progressText.textContent = `${progress}%`;
//     }
    
//     // Update button state
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (actionButton) {
//         if (progress >= 100) {
//             actionButton.classList.remove('start-button', 'resume');
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//             localStorage.setItem(`form_${formId}_completed`, 'true');
//         } else if (progress > 0) {
//             actionButton.classList.remove('start-button', 'completed');
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//             localStorage.setItem(`form_${formId}_completed`, 'false');
//         } else {
//             actionButton.classList.remove('resume', 'completed');
//             actionButton.classList.add('start-button');
//             actionButton.innerHTML = 'Start Now';
//             actionButton.disabled = false;
//             localStorage.setItem(`form_${formId}_completed`, 'false');
//         }
//     }
    
//     return progress;
// }

// // Form-specific field definitions
// const formFieldMap = {
//     '119': ['field_5upd54', 'field_snsot4', 'field_joyoa4'],
//     '138': ['field_nig2u2'],
// 	'115': ['field_m06yg35-i683_first', 'field_2wppm35-i683', 'field_1ow2h5-i683', 'field_ed34635-i683', 'field_4ay565-i683', 'field_8xg2435-i683']
// };
// field_m06yg35-i734_first
// // Form-specific tab definitions
// const formTabMap = {
//     '119': 'benefits',
//     '138': 'new-hires',
// 	'115': 'referral-partner'
// };

// // Monitor input changes for a specific form
// function monitorFormInputs(formId) {
//     // Use a more specific selector to avoid conflicts
//     const formSelector = `#frm_form_${formId}_container`;
    
//     // Use event delegation to minimize listeners
//     document.addEventListener('input', function(event) {
//         const formContainer = event.target.closest(formSelector);
//         if (formContainer && !event.target.hasAttribute('data-progress-monitored')) {
//             calculateFormProgress(formId, formFieldMap[formId]);
//         }
//     });
    
//     document.addEventListener('change', function(event) {
//         const formContainer = event.target.closest(formSelector);
//         if (formContainer && !event.target.hasAttribute('data-progress-monitored')) {
//             calculateFormProgress(formId, formFieldMap[formId]);
//         }
//     });
// }

// // Verify form completion on page load for any form
// function verifyFormCompletion(formId) {
//     const storedProgress = parseInt(localStorage.getItem(`form_${formId}_progress`) || '0');
//     const storedCompletion = localStorage.getItem(`form_${formId}_completed`) === 'true';
    
//     // Always recalculate to get actual progress
//     const actualProgress = calculateFormProgress(formId, formFieldMap[formId]);
    
//     // If the form is marked as completed but doesn't have 100% progress, fix it
//     if ((storedCompletion && actualProgress < 100) || (!storedCompletion && actualProgress === 100)) {
//         localStorage.setItem(`form_${formId}_completed`, actualProgress === 100 ? 'true' : 'false');
        
//         // Update button state
//         const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//         if (actionButton) {
//             if (actualProgress === 100) {
//                 actionButton.classList.remove('start-button', 'resume');
//                 actionButton.classList.add('completed');
//                 actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//                 actionButton.disabled = true;
//             } else if (actualProgress > 0) {
//                 actionButton.classList.remove('start-button', 'completed');
//                 actionButton.classList.add('resume');
//                 actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//                 actionButton.disabled = false;
//             } else {
//                 actionButton.classList.remove('resume', 'completed');
//                 actionButton.classList.add('start-button');
//                 actionButton.innerHTML = '<i class="fas fa-arrow-right arrow-icon"></i> Start Now';
//                 actionButton.disabled = false;
//             }
//         }
//     }
// }

// // Initialize form buttons and progress on page load
// function initializeForm(formId) {
//     // Get the actual progress by checking the fields
//     const actualProgress = calculateFormProgress(formId, formFieldMap[formId]);
    
//     // Update localStorage with actual progress
//     localStorage.setItem(`form_${formId}_progress`, actualProgress);
    
//     // Set completion status based on actual progress
//     const isCompleted = actualProgress === 100;
//     localStorage.setItem(`form_${formId}_completed`, isCompleted ? 'true' : 'false');
    
//     // Update progress text
//     const progressText = document.querySelector(`#progress-${formId}`);
//     if (progressText) {
//         progressText.textContent = `${actualProgress}%`;
//     }
    
//     // Update button appearance and functionality
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (actionButton) {
//         // Clear all classes first
//         actionButton.classList.remove('start-button', 'resume', 'completed');
        
//         if (isCompleted) {
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//         } else if (actualProgress > 0) {
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//         } else {
//             actionButton.classList.add('start-button');
//             actionButton.innerHTML = '<i class="fas fa-arrow-right arrow-icon"></i> Start Now';
//             actionButton.disabled = false;
//         }
        
//         // Ensure the tab attribute is set correctly
//         const tabId = formTabMap[formId];
//         if (tabId && !actionButton.hasAttribute('data-tab')) {
//             actionButton.setAttribute('data-tab', tabId);
//         }
        
//         // Set up event listener for the form button (if not already set)
//         if (!actionButton.hasAttribute('data-click-handler-set')) {
//             actionButton.addEventListener('click', function(event) {
//                 const clickedFormId = this.getAttribute('data-form-id');
//                 const clickedTabId = this.getAttribute('data-tab');
                
//                 if (clickedFormId && clickedTabId) {
//                     localStorage.setItem(`form_${clickedFormId}_last_active`, Date.now());
                    
//                     // Find and click the tab
//                     const menuItem = document.querySelector(`.menu-item[data-tab="${clickedTabId}"]`);
//                     if (menuItem) {
//                         // Prevent default to ensure our handler works
//                         event.preventDefault();
//                         menuItem.click();
//                     }
//                 }
//             });
            
//             // Mark that we've set the click handler
//             actionButton.setAttribute('data-click-handler-set', 'true');
//         }
//     }
    
//     // Monitor form inputs (if not already monitoring)
//     if (!document.querySelector(`#frm_form_${formId}_container`)?.hasAttribute('data-monitoring-set')) {
//         monitorFormInputs(formId);
//         document.querySelector(`#frm_form_${formId}_container`)?.setAttribute('data-monitoring-set', 'true');
//     }
// }

// //  Main initialization when document is loaded

// document.addEventListener('DOMContentLoaded', function() {
//     // For each form in the formFieldMap
//     for (const formId in formFieldMap) {
//         if (formFieldMap.hasOwnProperty(formId)) {
//             setTimeout(function() {
//                 initializeForm(formId);
                
//                 // Verify form completion after a slight delay to allow the DOM to fully initialize
//                 setTimeout(function() {
//                     verifyFormCompletion(formId);
//                 }, 200);
//             }, 100);
//         }
//     }
    
//     // Run again after a longer delay to catch any dynamically loaded forms
//     setTimeout(function() {
//         for (const formId in formFieldMap) {
//             if (formFieldMap.hasOwnProperty(formId)) {
//                 initializeForm(formId);
//                 verifyFormCompletion(formId);
//             }
//         }
//     }, 1000);
// });

// // Add a mutation observer to handle dynamically loaded forms
// const observer = new MutationObserver(function(mutations) {
//     for (const formId in formFieldMap) {
//         if (formFieldMap.hasOwnProperty(formId) && 
//             document.querySelector(`#frm_form_${formId}_container`) &&
//             !document.querySelector(`#frm_form_${formId}_container`).hasAttribute('data-observed')) {
            
//             initializeForm(formId);
//             verifyFormCompletion(formId);
//             document.querySelector(`#frm_form_${formId}_container`).setAttribute('data-observed', 'true');
//         }
//     }
// });

// // Start observing the document with the configured parameters
// observer.observe(document.body, { childList: true, subtree: true });








// // Form-specific field definitions (remain the same)
// const formFieldMap = {
//     '119': ['field_5upd54', 'field_snsot4', 'field_joyoa4'],
//     '138': ['field_nig2u2'],
//     '115': ['field_m06yg35-i763_first', 'field_2wppm35-0', 'field_t8ayn35-0_line1', 'field_7rwd35-0', 'frm_field_2456-2438-0_container', 'field_ed34635-0'],
//     '130': ['field_qhtx64', 'field_9zm354', 'field_7p7n3', 'field_zwgsl4', 'field_ldm8o4_line1'],
//     '113': ['field_yyf6', 'field_amrz-0', 'field_djy3q2', 'frm_field_2416_container'],
//     '139': ['field_bedgi3', 'field_yoq7n5', 'field_oc54p4', 'field_k2t8y4-0', 'field_r6s994-0', 'field_eaham'],
//     '98': ['frm_field_1942_container_colorValue', 'field_6xw0y4', 'ield_13eph4', 'field_t7g254', 'field_h6574', 'field_bxtli4', 'field_pdpwl4', 'field_a8unp4', 'field_amlrx_line1', 'field_amlrx_city', 'field_amlrx_state', 'field_amlrx_zip']
// };

// // Form-specific tab definitions (remain the same)
// const formTabMap = {
//     '119': 'benefits',
//     '138': 'new-hires',
//     '115': 'referral-partner',
//     '130': 'risk',
//     '113': 'integrations',
//     '139': 'tax',
//     '98': 'company-setup'
// };

// // Helper function to find the actual form field element
// function findFormField(fieldId, form) {
//     // First try direct ID
//     let field = form.querySelector(`#${fieldId}`);
//     if (field) return { element: field, type: 'direct' };

//     // Try various field types and containers
//     const selectors = [
//         // Radio button field
//         `[data-name="${fieldId}"]`,
//         `.frm_opt_container[data-name="${fieldId}"]`,
//         // Checkbox field
//         `.frm_checkbox[data-name="${fieldId}"]`,
//         `.frm_checkbox_container[data-name="${fieldId}"]`,
//         // Color picker
//         `#${fieldId}_container`,
//         `#${fieldId}_colorValue`,
//         // Select field
//         `select[data-name="${fieldId}"]`,
//         // Other input types
//         `input[data-name="${fieldId}"]`,
//         `textarea[data-name="${fieldId}"]`,
//         // General field container
//         `.frm_form_field[data-name="${fieldId}"]`,
//         `.field_${fieldId}_container`
//     ];

//     for (const selector of selectors) {
//         field = form.querySelector(selector);
//         if (field) {
//             return { element: field, type: selector.includes('container') ? 'container' : 'field' };
//         }
//     }

//     return null;
// }

// // Helper function to check if a field is filled
// function isFieldFilled(fieldId, form) {
//     const field = findFormField(fieldId, form);
//     if (!field) return false;

//     const { element, type } = field;

//     // Handle containers
//     if (type === 'container') {
//         // Radio buttons
//         if (element.classList.contains('frm_opt_container')) {
//             return element.querySelector('input[type="radio"]:checked') !== null;
//         }
//         // Checkboxes
//         if (element.classList.contains('frm_checkbox_container')) {
//             return element.querySelector('input[type="checkbox"]:checked') !== null;
//         }
//         // Color picker
//         if (fieldId.includes('color')) {
//             const colorInput = element.querySelector('input[type="text"]');
//             return colorInput && colorInput.value.trim() !== '';
//         }
//         // Other container types
//         const inputs = element.querySelectorAll('input, select, textarea');
//         return Array.from(inputs).some(input => {
//             if (input.type === 'radio' || input.type === 'checkbox') {
//                 return input.checked;
//             }
//             return input.value.trim() !== '';
//         });
//     }

//     // Handle direct fields
//     if (element.tagName === 'INPUT') {
//         switch (element.type) {
//             case 'radio':
//                 return form.querySelector(`input[name="${element.name}"]:checked`) !== null;
//             case 'checkbox':
//                 return element.checked;
//             case 'color':
//                 return element.value !== '';
//             default:
//                 return element.value.trim() !== '';
//         }
//     }

//     // Handle select elements
//     if (element.tagName === 'SELECT') {
//         return element.value !== '';
//     }

//     // Handle textarea elements
//     if (element.tagName === 'TEXTAREA') {
//         return element.value.trim() !== '';
//     }

//     return false;
// }

// // Generic form progress calculator
// function calculateFormProgress(formId, fieldIds) {
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form) return 0;
    
//     let filledFields = 0;
//     let totalFields = fieldIds.length;
    
//     fieldIds.forEach(id => {
//         if (isFieldFilled(id, form)) {
//             filledFields++;
//         }
//     });
    
//     return totalFields > 0 ? Math.round((filledFields / totalFields) * 100) : 0;
// }

// // Update UI without modifying form styles (remains the same)
// function updateFormUI(formId, progress) {
//     const progressText = document.querySelector(`#progress-${formId}`);
//     if (progressText) {
//         progressText.textContent = `${progress}%`;
//     }
    
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (actionButton) {
//         const preserveClasses = Array.from(actionButton.classList)
//             .filter(cls => !['start-button', 'resume', 'completed'].includes(cls));
        
//         actionButton.className = preserveClasses.join(' ');
        
//         if (progress >= 100) {
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//         } else if (progress > 0) {
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//         } else {
//             actionButton.classList.add('start-button');
//             actionButton.innerHTML = 'Start Now';
//             actionButton.disabled = false;
//         }
//     }
    
//     localStorage.setItem(`form_${formId}_progress`, progress);
//     localStorage.setItem(`form_${formId}_completed`, progress >= 100 ? 'true' : 'false');
// }

// // Monitor form changes
// function monitorForm(formId) {
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form || form.hasAttribute('data-progress-monitor')) return;
    
//     form.setAttribute('data-progress-monitor', 'true');
    
//     let debounceTimeout;
//     const handleChange = () => {
//         clearTimeout(debounceTimeout);
//         debounceTimeout = setTimeout(() => {
//             const progress = calculateFormProgress(formId, formFieldMap[formId]);
//             updateFormUI(formId, progress);
//         }, 200);
//     };
    
//     ['input', 'change', 'colorpickerchange'].forEach(eventType => {
//         form.addEventListener(eventType, handleChange, { passive: true });
//     });
// }

// // Initialize button click handling (remains the same)
// function initializeButton(formId) {
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (!actionButton || actionButton.hasAttribute('data-click-initialized')) return;
    
//     actionButton.setAttribute('data-click-initialized', 'true');
    
//     if (formTabMap[formId]) {
//         actionButton.setAttribute('data-tab', formTabMap[formId]);
//     }
    
//     actionButton.addEventListener('click', (event) => {
//         const tabId = actionButton.getAttribute('data-tab');
//         if (tabId) {
//             localStorage.setItem(`form_${formId}_last_active`, Date.now());
//             const menuItem = document.querySelector(`.menu-item[data-tab="${tabId}"]`);
//             if (menuItem) {
//                 event.preventDefault();
//                 menuItem.click();
//             }
//         }
//     });
// }

// // Main initialization (remains the same)
// function initializeFormProgress() {
//     Object.keys(formFieldMap).forEach(formId => {
//         const progress = calculateFormProgress(formId, formFieldMap[formId]);
//         updateFormUI(formId, progress);
//         monitorForm(formId);
//         initializeButton(formId);
//     });
// }

// // Initialize on DOM load (remains the same)
// document.addEventListener('DOMContentLoaded', () => {
//     initializeFormProgress();
    
//     const observer = new MutationObserver(() => {
//         Object.keys(formFieldMap).forEach(formId => {
//             const form = document.querySelector(`#frm_form_${formId}_container`);
//             if (form && !form.hasAttribute('data-progress-monitor')) {
//                 const progress = calculateFormProgress(formId, formFieldMap[formId]);
//                 updateFormUI(formId, progress);
//                 monitorForm(formId);
//                 initializeButton(formId);
//             }
//         });
//     });
    
//     observer.observe(document.body, { childList: true, subtree: true });
// });









// // Form-specific field definitions (remain the same)
// const formFieldMap = {
//     '119': ['field_5upd54', 'field_snsot4', 'field_joyoa4'],
//     '138': ['field_nig2u2'],
// 	'115': ['field_m06yg35-i763_first'],
//     '130': ['field_qhtx64', 'field_9zm354', 'field_7p7n3', 'field_zwgsl4', 'field_ldm8o4'],
//     '113': ['field_yyf6', 'field_amrz', 'field_djy3q2', 'field_2416'],
//     '139': ['field_bedgi3', 'field_yoq7n5', 'field_oc54p4', 'field_k2t8y4', 'field_r6s994', 'field_eaham'],
//     '98': ['field_1942', 'field_6xw0y4', 'field_13eph4', 'field_t7g254', 'field_h6574', 'field_bxtli4', 'field_pdpwl4', 'field_a8unp4', 'field_amlrx']
// };

// // Form-specific tab definitions (remain the same)
// const formTabMap = {
//     '119': 'benefits',
//     '138': 'new-hires',
//     '115': 'referral-partner',
//     '130': 'risk',
//     '113': 'integrations',
//     '139': 'tax',
//     '98': 'company-setup'
// };

// // Helper function to find the form field element using flexible matching
// function findFormField(fieldId, form) {
//     // Strip any suffixes from the field ID first
//     const baseFieldId = fieldId.split('-')[0].split('_')[0];
    
//     // Try direct ID first (exact match)
//     let field = form.querySelector(`#${fieldId}`);
//     if (field) return { element: field, type: 'direct' };
    
//     // List of possible selectors using attribute selectors and partial matching
//     const selectors = [
//         // Try with the base field ID
//         `[id^="${baseFieldId}"]`,
//         `[data-name^="${baseFieldId}"]`,
        
//         // Common container patterns
//         `[id*="${baseFieldId}_container"]`,
//         `[id*="frm_field_${baseFieldId}_container"]`,
//         `#frm_field_${baseFieldId}_container`,
//         `[id*="${fieldId}_container"]`,
        
//         // Radio buttons and checkboxes
//         `.frm_opt_container[data-name*="${baseFieldId}"]`,
//         `.frm_checkbox[data-name*="${baseFieldId}"]`,
//         `.frm_radio[data-name*="${baseFieldId}"]`,
        
//         // Field specific containers
//         `.field_${baseFieldId}-container`,
//         `.field_${fieldId}-container`,
        
//         // More specific field types
//         `input[name*="${baseFieldId}"]`,
//         `input[id*="${baseFieldId}"]`,
//         `select[name*="${baseFieldId}"]`,
//         `textarea[name*="${baseFieldId}"]`
//     ];
    
//     // Try each selector
//     for (const selector of selectors) {
//         const elements = form.querySelectorAll(selector);
//         if (elements && elements.length > 0) {
//             // Return the first matching element
//             const element = elements[0];
//             const isContainer = element.classList.contains('frm_form_field') || 
//                                element.classList.contains('frm_opt_container') ||
//                                element.classList.contains('frm_checkbox') ||
//                                element.classList.contains('frm_radio') ||
//                                selector.includes('container');
            
//             return { 
//                 element: element, 
//                 type: isContainer ? 'container' : 'field'
//             };
//         }
//     }
    
//     return null;
// }

// // Improved helper function to check if a field is filled
// function isFieldFilled(fieldId, form) {
//     const field = findFormField(fieldId, form);
//     if (!field) return false;

//     const { element, type } = field;

//     // Handle containers
//     if (type === 'container') {
//         // Radio buttons
//         if (element.classList.contains('frm_opt_container') || element.classList.contains('frm_radio')) {
//             return element.querySelector('input[type="radio"]:checked') !== null;
//         }
//         // Checkboxes
//         if (element.classList.contains('frm_checkbox')) {
//             return element.querySelector('input[type="checkbox"]:checked') !== null;
//         }
//         // Color picker
//         if (fieldId.includes('color') || element.querySelector('input[type="color"]')) {
//             const colorInput = element.querySelector('input[type="text"], input[type="color"]');
//             return colorInput && colorInput.value.trim() !== '';
//         }
//         // Look for any inputs within the container
//         const inputs = element.querySelectorAll('input, select, textarea');
//         return Array.from(inputs).some(input => {
//             if (input.type === 'radio' || input.type === 'checkbox') {
//                 return input.checked;
//             }
//             return input.value.trim() !== '';
//         });
//     }

//     // Handle direct fields
//     if (element.tagName === 'INPUT') {
//         switch (element.type) {
//             case 'radio':
//                 // Find all radio buttons with the same name
//                 const radioGroup = form.querySelectorAll(`input[name="${element.name}"]`);
//                 return Array.from(radioGroup).some(radio => radio.checked);
//             case 'checkbox':
//                 return element.checked;
//             case 'color':
//                 return element.value !== '';
//             default:
//                 return element.value.trim() !== '';
//         }
//     }

//     // Handle select elements
//     if (element.tagName === 'SELECT') {
//         return element.value !== '';
//     }

//     // Handle textarea elements
//     if (element.tagName === 'TEXTAREA') {
//         return element.value.trim() !== '';
//     }

//     return false;
// }

// // Generic form progress calculator - with logging for debugging
// function calculateFormProgress(formId, fieldIds) {
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form) return 0;
    
//     let filledFields = 0;
//     let totalFields = fieldIds.length;
//     let missingFields = [];
    
//     fieldIds.forEach(id => {
//         const field = findFormField(id, form);
//         if (!field) {
//             missingFields.push(id);
//         } else if (isFieldFilled(id, form)) {
//             filledFields++;
//         }
//     });
    
//     // Only log if there are missing fields (helps with debugging)
//     if (missingFields.length > 0 && console && console.debug) {
//         console.debug(`Form ${formId} has ${missingFields.length} missing fields:`, missingFields);
//     }
    
//     return totalFields > 0 ? Math.round((filledFields / totalFields) * 100) : 0;
// }

// // Update UI without modifying form styles (remains the same)
// function updateFormUI(formId, progress) {
//     const progressText = document.querySelector(`#progress-${formId}`);
//     if (progressText) {
//         progressText.textContent = `${progress}% Completed`;
//     }
    
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (actionButton) {
//         const preserveClasses = Array.from(actionButton.classList)
//             .filter(cls => !['start-button', 'resume', 'completed'].includes(cls));
        
//         actionButton.className = preserveClasses.join(' ');
        
//         if (progress >= 100) {
//             actionButton.classList.add('completed');
//             actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
//             actionButton.disabled = true;
//         } else if (progress > 0) {
//             actionButton.classList.add('resume');
//             actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
//             actionButton.disabled = false;
//         } else {
//             actionButton.classList.add('start-button');
//             actionButton.innerHTML = 'Start Now';
//             actionButton.disabled = false;
//         }
//     }
    
//     localStorage.setItem(`form_${formId}_progress`, progress);
//     localStorage.setItem(`form_${formId}_completed`, progress >= 100 ? 'true' : 'false');
// }

// // Monitor form changes - with error handling
// function monitorForm(formId) {
//     const form = document.querySelector(`#frm_form_${formId}_container`);
//     if (!form || form.hasAttribute('data-progress-monitor')) return;
    
//     form.setAttribute('data-progress-monitor', 'true');
    
//     let debounceTimeout;
//     const handleChange = () => {
//         clearTimeout(debounceTimeout);
//         debounceTimeout = setTimeout(() => {
//             try {
//                 const progress = calculateFormProgress(formId, formFieldMap[formId]);
//                 updateFormUI(formId, progress);
//             } catch (error) {
//                 console.error(`Error updating form ${formId} progress:`, error);
//             }
//         }, 200);
//     };
    
//     ['input', 'change', 'colorpickerchange'].forEach(eventType => {
//         form.addEventListener(eventType, handleChange, { passive: true });
//     });
// }

// // Initialize button click handling (remains the same)
// function initializeButton(formId) {
//     const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
//     if (!actionButton || actionButton.hasAttribute('data-click-initialized')) return;
    
//     actionButton.setAttribute('data-click-initialized', 'true');
    
//     if (formTabMap[formId]) {
//         actionButton.setAttribute('data-tab', formTabMap[formId]);
//     }
    
//     actionButton.addEventListener('click', (event) => {
//         const tabId = actionButton.getAttribute('data-tab');
//         if (tabId) {
//             localStorage.setItem(`form_${formId}_last_active`, Date.now());
//             const menuItem = document.querySelector(`.menu-item[data-tab="${tabId}"]`);
//             if (menuItem) {
//                 event.preventDefault();
//                 menuItem.click();
//             }
//         }
//     });
// }

// // Main initialization - with error handling
// function initializeFormProgress() {
//     Object.keys(formFieldMap).forEach(formId => {
//         try {
//             const progress = calculateFormProgress(formId, formFieldMap[formId]);
//             updateFormUI(formId, progress);
//             monitorForm(formId);
//             initializeButton(formId);
//         } catch (error) {
//             console.error(`Error initializing form ${formId}:`, error);
//         }
//     });
// }

// // Initialize on DOM load - with error handling
// document.addEventListener('DOMContentLoaded', () => {
//     try {
//         initializeFormProgress();
        
//         const observer = new MutationObserver(() => {
//             Object.keys(formFieldMap).forEach(formId => {
//                 try {
//                     const form = document.querySelector(`#frm_form_${formId}_container`);
//                     if (form && !form.hasAttribute('data-progress-monitor')) {
//                         const progress = calculateFormProgress(formId, formFieldMap[formId]);
//                         updateFormUI(formId, progress);
//                         monitorForm(formId);
//                         initializeButton(formId);
//                     }
//                 } catch (error) {
//                     console.error(`Error in mutation observer for form ${formId}:`, error);
//                 }
//             });
//         });
        
//         observer.observe(document.body, { childList: true, subtree: true });
//     } catch (error) {
//         console.error('Error in form progress initialization:', error);
//     }
// });










// Form-specific field definitions (remain the same)
const formFieldMap = {
    '119': ['field_5upd54', 'field_snsot4', 'field_joyoa4'],
    '138': ['field_nig2u2'],
    '115': ['field_m06yg35-0_first', 'field_teo8n35-0'],
    '130': ['field_qhtx64', 'field_9zm354', 'field_7p7n3', 'field_zwgsl4', 'field_ldm8o4'],
    '113': ['field_yyf6', 'field_amrz', 'field_djy3q2', 'field_2416'],
    '139': ['field_bedgi3', 'field_yoq7n5', 'field_oc54p4', 'field_k2t8y4', 'field_r6s994', 'field_eaham'],
    '98': ['field_1942', 'field_6xw0y4', 'field_13eph4', 'field_t7g254', 'field_h6574', 'field_bxtli4', 'field_pdpwl4', 'field_a8unp4', 'field_amlrx']
};

// Form-specific tab definitions (remain the same)
const formTabMap = {
    '119': 'benefits',
    '138': 'new-hires',
    '115': 'referral-partner',
    '130': 'risk',
    '113': 'integrations',
    '139': 'tax',
    '98': 'company-setup'
};

// Helper function to find the form field element using flexible matching
function findFormField(fieldId, form) {
    // Strip any suffixes from the field ID first
    const baseFieldId = fieldId.split('-')[0].split('_')[0];
    
    // Try direct ID first (exact match)
    let field = form.querySelector(`#${fieldId}`);
    if (field) return { element: field, type: 'direct' };
    
    // List of possible selectors using attribute selectors and partial matching
    const selectors = [
        // Try with the base field ID
        `[id^="${baseFieldId}"]`,
        `[data-name^="${baseFieldId}"]`,
        
        // Common container patterns
        `[id*="${baseFieldId}_container"]`,
        `[id*="frm_field_${baseFieldId}_container"]`,
        `#frm_field_${baseFieldId}_container`,
        `[id*="${fieldId}_container"]`,
        
        // Radio buttons and checkboxes
        `.frm_opt_container[data-name*="${baseFieldId}"]`,
        `.frm_checkbox[data-name*="${baseFieldId}"]`,
        `.frm_radio[data-name*="${baseFieldId}"]`,
        
        // Field specific containers
        `.field_${baseFieldId}-container`,
        `.field_${fieldId}-container`,
        
        // More specific field types
        `input[name*="${baseFieldId}"]`,
        `input[id*="${baseFieldId}"]`,
        `select[name*="${baseFieldId}"]`,
        `textarea[name*="${baseFieldId}"]`
    ];
    
    // Try each selector
    for (const selector of selectors) {
        const elements = form.querySelectorAll(selector);
        if (elements && elements.length > 0) {
            // Return the first matching element
            const element = elements[0];
            const isContainer = element.classList.contains('frm_form_field') || 
                               element.classList.contains('frm_opt_container') ||
                               element.classList.contains('frm_checkbox') ||
                               element.classList.contains('frm_radio') ||
                               selector.includes('container');
            
            return { 
                element: element, 
                type: isContainer ? 'container' : 'field'
            };
        }
    }
    
    return null;
}

// Improved helper function to check if a field is filled
function isFieldFilled(fieldId, form) {
    const field = findFormField(fieldId, form);
    if (!field) return false;

    const { element, type } = field;

    // Handle containers
    if (type === 'container') {
        // Radio buttons
        if (element.classList.contains('frm_opt_container') || element.classList.contains('frm_radio')) {
            return element.querySelector('input[type="radio"]:checked') !== null;
        }
        // Checkboxes
        if (element.classList.contains('frm_checkbox')) {
            return element.querySelector('input[type="checkbox"]:checked') !== null;
        }
        // Color picker
        if (fieldId.includes('color') || element.querySelector('input[type="color"]')) {
            const colorInput = element.querySelector('input[type="text"], input[type="color"]');
            return colorInput && colorInput.value.trim() !== '';
        }
        // Look for any inputs within the container
        const inputs = element.querySelectorAll('input, select, textarea');
        return Array.from(inputs).some(input => {
            if (input.type === 'radio' || input.type === 'checkbox') {
                return input.checked;
            }
            return input.value.trim() !== '';
        });
    }

    // Handle direct fields
    if (element.tagName === 'INPUT') {
        switch (element.type) {
            case 'radio':
                // Find all radio buttons with the same name
                const radioGroup = form.querySelectorAll(`input[name="${element.name}"]`);
                return Array.from(radioGroup).some(radio => radio.checked);
            case 'checkbox':
                return element.checked;
            case 'color':
                return element.value !== '';
            default:
                return element.value.trim() !== '';
        }
    }

    // Handle select elements
    if (element.tagName === 'SELECT') {
        return element.value !== '';
    }

    // Handle textarea elements
    if (element.tagName === 'TEXTAREA') {
        return element.value.trim() !== '';
    }

    return false;
}

// Generic form progress calculator - with logging for debugging
function calculateFormProgress(formId, fieldIds) {
    const form = document.querySelector(`#frm_form_${formId}_container`);
    if (!form) return 0;
    
    let filledFields = 0;
    let totalFields = fieldIds.length;
    let missingFields = [];
    
    fieldIds.forEach(id => {
        const field = findFormField(id, form);
        if (!field) {
            missingFields.push(id);
        } else if (isFieldFilled(id, form)) {
            filledFields++;
        }
    });
    
    // Only log if there are missing fields (helps with debugging)
    if (missingFields.length > 0 && console && console.debug) {
        console.debug(`Form ${formId} has ${missingFields.length} missing fields:`, missingFields);
    }
    
    return totalFields > 0 ? Math.round((filledFields / totalFields) * 100) : 0;
}

// Update UI and save progress to localStorage
function updateFormUI(formId, progress) {
    const progressText = document.querySelector(`#progress-${formId}`);
    if (progressText) {
        progressText.textContent = `${progress}% Completed`;
    }
    
    const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
    if (actionButton) {
        const preserveClasses = Array.from(actionButton.classList)
            .filter(cls => !['start-button', 'resume', 'completed'].includes(cls));
        
        actionButton.className = preserveClasses.join(' ');
        
        if (progress >= 100) {
            actionButton.classList.add('completed');
            actionButton.innerHTML = '<i class="fas fa-check check-icon"></i> Completed';
            actionButton.disabled = true;
        } else if (progress > 0) {
            actionButton.classList.add('resume');
            actionButton.innerHTML = '<i class="fas fa-play play-icon"></i> Resume';
            actionButton.disabled = false;
        } else {
            actionButton.classList.add('start-button');
            actionButton.innerHTML = 'Start Now';
            actionButton.disabled = false;
        }
    }
    
    // Save to localStorage for persistence
    localStorage.setItem(`form_${formId}_progress`, progress);
    localStorage.setItem(`form_${formId}_completed`, progress >= 100 ? 'true' : 'false');
    localStorage.setItem(`form_${formId}_last_saved`, Date.now());
}

// Function to handle form submission or save later
function handleFormSubmission(formId) {
    // Get the current progress before submission
    const progress = calculateFormProgress(formId, formFieldMap[formId]);
    // Store it in localStorage with a timestamp
    localStorage.setItem(`form_${formId}_progress`, progress);
    localStorage.setItem(`form_${formId}_completed`, progress >= 100 ? 'true' : 'false');
    localStorage.setItem(`form_${formId}_last_saved`, Date.now());
}

// Monitor form changes - with persistence
function monitorForm(formId) {
    const form = document.querySelector(`#frm_form_${formId}_container`);
    if (!form || form.hasAttribute('data-progress-monitor')) return;
    
    form.setAttribute('data-progress-monitor', 'true');
    
    let debounceTimeout;
    const handleChange = () => {
        clearTimeout(debounceTimeout);
        debounceTimeout = setTimeout(() => {
            try {
                const progress = calculateFormProgress(formId, formFieldMap[formId]);
                updateFormUI(formId, progress);
            } catch (error) {
                console.error(`Error updating form ${formId} progress:`, error);
            }
        }, 200);
    };
    
    ['input', 'change', 'colorpickerchange'].forEach(eventType => {
        form.addEventListener(eventType, handleChange, { passive: true });
    });
    
    // Add event listeners for form submission and save later buttons
    const formElement = form.querySelector(`form[id^="form_${formId}"]`);
    if (formElement) {
        // For regular submission
        formElement.addEventListener('submit', () => {
            handleFormSubmission(formId);
        });
        
        // For "Save Draft" or "Save Later" buttons
        const saveDraftButtons = formElement.querySelectorAll('.frm_save_draft');
        saveDraftButtons.forEach(button => {
            button.addEventListener('click', () => {
                handleFormSubmission(formId);
            });
        });
    }
}

// Initialize button click handling
function initializeButton(formId) {
    const actionButton = document.querySelector(`.card[data-form-id="${formId}"] .action-button`);
    if (!actionButton || actionButton.hasAttribute('data-click-initialized')) return;
    
    actionButton.setAttribute('data-click-initialized', 'true');
    
    if (formTabMap[formId]) {
        actionButton.setAttribute('data-tab', formTabMap[formId]);
    }
    
    actionButton.addEventListener('click', (event) => {
        const tabId = actionButton.getAttribute('data-tab');
        if (tabId) {
            localStorage.setItem(`form_${formId}_last_active`, Date.now());
            const menuItem = document.querySelector(`.menu-item[data-tab="${tabId}"]`);
            if (menuItem) {
                event.preventDefault();
                menuItem.click();
            }
        }
    });
}

// Function to load progress from localStorage
function loadSavedProgress() {
    Object.keys(formFieldMap).forEach(formId => {
        const savedProgress = localStorage.getItem(`form_${formId}_progress`);
        if (savedProgress !== null) {
            updateFormUI(formId, parseInt(savedProgress, 10));
        }
    });
}

// Function to calculate and initialize form progress
function initializeFormProgress() {
    Object.keys(formFieldMap).forEach(formId => {
        try {
            // Check if we're viewing a specific form
            const form = document.querySelector(`#frm_form_${formId}_container`);
            if (form) {
                // If we're on a form page, calculate and update progress
                const progress = calculateFormProgress(formId, formFieldMap[formId]);
                updateFormUI(formId, progress);
                monitorForm(formId);
            }
            
            // Initialize buttons regardless of page
            initializeButton(formId);
        } catch (error) {
            console.error(`Error initializing form ${formId}:`, error);
        }
    });
}

// Add event listeners to the submit and save buttons globally
function attachFormActionListeners() {
    // For Formidable Forms submit buttons
    document.querySelectorAll('.frm_button_submit').forEach(button => {
        const form = button.closest('form');
        if (form) {
            const formIdMatch = form.id.match(/form_(\d+)/);
            if (formIdMatch && formIdMatch[1]) {
                const formId = formIdMatch[1];
                if (!button.hasAttribute('data-progress-handler')) {
                    button.setAttribute('data-progress-handler', 'true');
                    button.addEventListener('click', () => {
                        handleFormSubmission(formId);
                    });
                }
            }
        }
    });
    
    // For save draft buttons
    document.querySelectorAll('.frm_save_draft').forEach(button => {
        const form = button.closest('form');
        if (form) {
            const formIdMatch = form.id.match(/form_(\d+)/);
            if (formIdMatch && formIdMatch[1]) {
                const formId = formIdMatch[1];
                if (!button.hasAttribute('data-progress-handler')) {
                    button.setAttribute('data-progress-handler', 'true');
                    button.addEventListener('click', () => {
                        handleFormSubmission(formId);
                    });
                }
            }
        }
    });
}

// Support for AJAX form submissions
function setupAjaxListener() {
    // Listen for custom events that might be triggered after AJAX submissions
    document.addEventListener('frmFormComplete', function(event) {
        if (event.detail && event.detail.form) {
            const formIdMatch = event.detail.form.id.match(/form_(\d+)/);
            if (formIdMatch && formIdMatch[1]) {
                const formId = formIdMatch[1];
                handleFormSubmission(formId);
            }
        }
    });
    
    // Alternative method to detect AJAX form submissions using XHR intercept
    const originalXhrSend = XMLHttpRequest.prototype.send;
    XMLHttpRequest.prototype.send = function(body) {
        const xhr = this;
        
        // Check if this is a form submission
        if (body && body.toString().includes('action=frm_submit')) {
            // Add onreadystatechange listener
            const originalOnReadyStateChange = xhr.onreadystatechange;
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    // Try to extract form ID from the request
                    const formIdMatch = body.toString().match(/form_id=(\d+)/);
                    if (formIdMatch && formIdMatch[1]) {
                        const formId = formIdMatch[1];
                        handleFormSubmission(formId);
                    }
                }
                
                if (originalOnReadyStateChange) {
                    originalOnReadyStateChange.apply(this, arguments);
                }
            };
        }
        
        return originalXhrSend.apply(this, arguments);
    };
}

// Initialize everything on DOM load
document.addEventListener('DOMContentLoaded', () => {
    try {
        // First load saved progress from localStorage
        loadSavedProgress();
        
        // Then initialize current forms if they're present
        initializeFormProgress();
        
        // Attach form action listeners for submit and save buttons
        attachFormActionListeners();
        
        // Setup ajax submission listener
        setupAjaxListener();
        
        // Set up a mutation observer to handle dynamically loaded forms
        const observer = new MutationObserver((mutations) => {
            let needsUpdate = false;
            
            mutations.forEach(mutation => {
                if (mutation.addedNodes.length) {
                    // Check if any of the added nodes are form elements or contain form elements
                    for (let i = 0; i < mutation.addedNodes.length; i++) {
                        const node = mutation.addedNodes[i];
                        if (node.nodeType === 1) { // Element node
                            if (node.matches && 
                                (node.matches('form[id^="form_"]') || 
                                node.querySelector('form[id^="form_"]'))) {
                                needsUpdate = true;
                                break;
                            }
                        }
                    }
                }
            });
            
            if (needsUpdate) {
                // Re-attach event listeners and re-initialize progress
                initializeFormProgress();
                attachFormActionListeners();
            }
        });
        
        observer.observe(document.body, { childList: true, subtree: true });
        
        // Check for URL parameters that might indicate a form was just submitted
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.has('frm_action') && (urlParams.get('frm_action') === 'create' || urlParams.get('frm_action') === 'update')) {
            // This might indicate a form was just submitted - reload saved progress
            loadSavedProgress();
        }
        
    } catch (error) {
        console.error('Error in form progress initialization:', error);
    }
});

// Add a listener for page visibility changes to handle tab switching
document.addEventListener('visibilitychange', () => {
    if (!document.hidden) {
        // When the page becomes visible again, reload saved progress
        // This helps when returning to the overview page after form submission
        loadSavedProgress();
    }
});

// Add a listener for the beforeunload event to ensure progress is saved
window.addEventListener('beforeunload', () => {
    // Save current progress for any visible forms
    Object.keys(formFieldMap).forEach(formId => {
        const form = document.querySelector(`#frm_form_${formId}_container`);
        if (form) {
            const progress = calculateFormProgress(formId, formFieldMap[formId]);
            localStorage.setItem(`form_${formId}_progress`, progress);
            localStorage.setItem(`form_${formId}_completed`, progress >= 100 ? 'true' : 'false');
            localStorage.setItem(`form_${formId}_last_saved`, Date.now());
        }
    });
});
</script>
<!-- end Simple Custom CSS and JS -->
