<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
// jQuery(document).ready(function ($) {
//     // Inject styles for the enhanced select
//     function injectStyles() {
//         const styles = `
//             .enhanced-select-container {
//                 position: relative;
//                 width: 100%;
//                 box-sizing: border-box;
//             }

//             .enhanced-select-input {
//                 width: 100%;
//                 padding: 8px 12px;
//                 border: 1px solid #ddd;
//                 border-radius: 4px;
//                 font-size: 14px;
//                 line-height: 1.5;
//                 box-sizing: border-box;
//                 margin-bottom: 8px;
//             }

//             .enhanced-select-input:focus {
//                 outline: none;
//                 border-color: #007bff;
//                 box-shadow: 0 0 0 2px rgba(0,123,255,.25);
//             }

//             .enhanced-select-tags {
//                 display: flex;
//                 flex-wrap: wrap;
//                 gap: 8px;
//                 padding: 8px 0;
//                 min-height: 30px;
//                 margin-top: 8px;
//             }

//             .enhanced-select-tag {
//                 display: inline-flex;
//                 align-items: center;
//                 background: #f0f0f0;
//                 border-radius: 4px;
//                 padding: 6px 10px;
//                 font-size: 14px;
//                 line-height: 1.5;
//                 margin: 2px;
//             }

//             .enhanced-select-tag-remove {
//                 margin-left: 8px;
//                 cursor: pointer;
//                 color: #dc3545;
//                 font-size: 16px;
//                 line-height: 1;
//                 font-weight: bold;
//             }

//             .enhanced-select-dropdown {
//                 position: absolute;
//                 top: 42%;
//                 left: 0;
//                 right: 0;
//                 background: white;
//                 border: 1px solid #ddd;
//                 border-radius: 4px;
//                 max-height: 200px;
//                 overflow-y: auto;
//                 z-index: 1000;
//                 box-shadow: 0 2px 4px rgba(0,0,0,.1);
//                 display: none;
//             }

//             .enhanced-select-option {
//                 padding: 8px 12px;
//                 cursor: pointer;
//                 font-size: 14px;
//                 line-height: 1.5;
//                 transition: background-color 0.2s;
//             }

//             .enhanced-select-option:hover {
//                 background: #0000000D;
//             }

//             .enhanced-select-container select {
//                 display: none;
//             }

//             .enhanced-select-dropdown::-webkit-scrollbar {
//                 width: 8px;
//             }

//             .enhanced-select-dropdown::-webkit-scrollbar-track {
//                 background: #f1f1f1;
//                 border-radius: 4px;
//             }

//             .enhanced-select-dropdown::-webkit-scrollbar-thumb {
//                 background: #888;
//                 border-radius: 4px;
//             }

//             .enhanced-select-dropdown::-webkit-scrollbar-thumb:hover {
//                 background: #555;
//             }
//         `;
//         $('<style>').text(styles).appendTo('head');
//     }

//     // Function to enhance the select element
//     function enhanceSelect(selectElement) {
//         const $select = $(selectElement);
//         if ($select.closest('.enhanced-select-container').length) return;

//         const isMultiple = $select.prop('multiple');

//         const $wrapper = $('<div class="enhanced-select-container"></div>');
//         const $input = $('<input type="text" class="enhanced-select-input" placeholder="Type to search...">');
//         const $dropdown = $('<div class="enhanced-select-dropdown"></div>');
//         const $tagsContainer = $('<div class="enhanced-select-tags"></div>');

//         $wrapper.append($input, $dropdown, $tagsContainer);
//         $select.before($wrapper);
//         $select.appendTo($wrapper);

//         // Add tags for pre-selected options
//         $select.find('option:selected').each(function () {
//             if ($(this).val()) {
//                 addTag($(this).text(), $(this).val());
//             }
//         });

//         // Function to add a tag
//         function addTag(text, value) {
//             if (!isMultiple) {
//                 $tagsContainer.empty();
//                 $select.find('option').prop('selected', false);
//             }

//             if ($tagsContainer.find(`[data-value="${value}"]`).length === 0) {
//                 const $tag = $(`
//                     <div class="enhanced-select-tag" data-value="${value}">
//                         <span>${text}</span>
//                         <span class="enhanced-select-tag-remove">×</span>
//                     </div>
//                 `);

//                 $tagsContainer.append($tag);
//                 $select.find(`option[value="${value}"]`).prop('selected', true);
//                 $select.trigger('change');
//                 updatePlaceholder();
//             }
//         }

//         // Handle input and focus events
//         $input.on('input focus', function () {
//             const searchText = $(this).val().toLowerCase();
//             $dropdown.empty();

//             $select.find('option').each(function () {
//                 const optionText = $(this).text().toLowerCase();
//                 const optionValue = $(this).val();

//                 if (optionText.includes(searchText)) {
//                     if (isMultiple && $(this).prop('selected')) {
//                         return;
//                     }

//                     const $option = $(`
//                         <div class="enhanced-select-option" data-value="${optionValue}">
//                             ${$(this).text()}
//                         </div>
//                     `);

//                     $dropdown.append($option);
//                 }
//             });

//             if ($dropdown.children().length > 0) {
//                 $dropdown.show();
//             } else {
//                 $dropdown.hide();
//             }
//         });

//         // Handle option selection
//         $dropdown.on('click', '.enhanced-select-option', function () {
//             const value = $(this).data('value');
//             const text = $(this).text();

//             addTag(text, value);
//             $input.val('').focus();
//             $dropdown.hide();
//             updatePlaceholder();
//         });

//         // Handle tag removal
//         $tagsContainer.on('click', '.enhanced-select-tag-remove', function () {
//             const $tag = $(this).parent();
//             const value = $tag.data('value');

//             $tag.remove();
//             $select.find(`option[value="${value}"]`).prop('selected', false);
//             $select.trigger('change');
//             updatePlaceholder();
//         });

//         // Hide dropdown when clicking outside
//         $(document).on('click', function (e) {
//             if (!$(e.target).closest($wrapper).length) {
//                 $dropdown.hide();
//             }
//         });

//         // Update placeholder based on tags
//         function updatePlaceholder() {
//             const tagCount = $tagsContainer.children().length;
//             if (tagCount > 0) {
//                 $input.attr('placeholder', isMultiple ? 'Add another...' : 'Change selection...');
//             } else {
//                 $input.attr('placeholder', 'Type to search...');
//             }
//         }

//         updatePlaceholder();
//     }

//     // Initialize the enhanced select for #field_3ktv4 on step 4
//     function initializeStep4() {
//         const $field = $('#field_3ktv4');
//         if ($field.length && !$field.closest('.enhanced-select-container').length) {
//             enhanceSelect($field[0]);
//             $('.enhanced-select-container').show(); // Show the enhanced select container
//         }
//     }

//     // Inject styles
//     injectStyles();

//     // Initialize step 4 field when the page loads (if already on step 4)
//     if ($('.frm_page_4').length) {
//         initializeStep4();
//     }

//     // Reinitialize when the form is completed (if needed)
//     $(document).on('frmFormComplete', initializeStep4);

//     // Observe DOM changes to handle dynamic fields
//     const observer = new MutationObserver(function (mutations) {
//         mutations.forEach(function (mutation) {
//             if (mutation.addedNodes && mutation.addedNodes.length > 0) {
//                 initializeStep4();
//             }
//         });
//     });

//     observer.observe(document.body, {
//         childList: true,
//         subtree: true
//     });

//     // Specific handling for multi-step form (step 4)
//     $(document).on('frmPageChanged', function (e, pageIndex) {
//         if (pageIndex === 3) { // Page 4 (zero-based index)
//             initializeStep4();
//         } else {
//             // Hide the enhanced select container on other steps
//             $('.enhanced-select-container').hide();
//         }
//     });
// });



// jQuery(document).ready(function ($) {
//     // Inject styles for the enhanced select
//     function injectStyles() {
//         const styles = `
//             .enhanced-select-container {
//                 position: relative;
//                 width: 100%;
//             }
//             .enhanced-select-input {
//                 width: 100%;
//                 padding: 8px 12px;
//                 border: 1px solid #ddd;
//                 border-radius: 4px;
//                 font-size: 14px;
//             }
//             .enhanced-select-tags {
//                 display: flex;
//                 flex-wrap: wrap;
//                 gap: 8px;
//                 margin-top: 8px;
//             }
//             .enhanced-select-tag {
//                 display: inline-flex;
//                 align-items: center;
//                 background: #f0f0f0;
//                 border-radius: 4px;
//                 padding: 6px 10px;
//                 font-size: 14px;
//             }
//             .enhanced-select-tag-remove {
//                 margin-left: 8px;
//                 cursor: pointer;
//                 color: #dc3545;
//                 font-weight: bold;
//             }
//             .enhanced-select-dropdown {
//                 position: absolute;
//                 top: 100%;
//                 left: 0;
//                 right: 0;
//                 background: white;
//                 border: 1px solid #ddd;
//                 border-radius: 4px;
//                 max-height: 200px;
//                 overflow-y: auto;
//                 z-index: 1000;
//                 display: none;
//             }
//             .enhanced-select-option {
//                 padding: 8px 12px;
//                 cursor: pointer;
//                 font-size: 14px;
//             }
//             .enhanced-select-option:hover {
//                 background: #f0f0f0;
//             }
//         `;
//         $('<style>').text(styles).appendTo('head');
//     }

//     // Enhanced select function
//     function enhanceMultiSelect(selectElement) {
//         const $select = $(selectElement);
        
//         // Prevent re-initialization
//         if ($select.data('enhanced')) return;
//         $select.data('enhanced', true);

//         // Create enhanced select container
//         const $container = $('<div class="enhanced-select-container"></div>');
//         const $input = $('<input type="text" class="enhanced-select-input" placeholder="Search and add states">');
//         const $tagsContainer = $('<div class="enhanced-select-tags"></div>');
//         const $dropdown = $('<div class="enhanced-select-dropdown"></div>');

//         // Wrap the original select
//         $select.hide().after($container);
//         $container.append($input, $tagsContainer, $dropdown);

//         // Populate dropdown
//         function populateDropdown(searchTerm = '') {
//             $dropdown.empty();
//             $select.find('option').each(function() {
//                 const $option = $(this);
//                 const text = $option.text();
//                 const value = $option.val();

//                 // Skip if already selected or doesn't match search
//                 if ($option.prop('selected') || 
//                     (searchTerm && !text.toLowerCase().includes(searchTerm.toLowerCase()))) {
//                     return;
//                 }

//                 const $dropdownOption = $(`
//                     <div class="enhanced-select-option" 
//                          data-value="${value}">
//                         ${text}
//                     </div>
//                 `);
//                 $dropdown.append($dropdownOption);
//             });

//             $dropdown.toggle($dropdown.children().length > 0);
//         }

//         // Add tag function
//         function addTag(text, value) {
//             // Prevent duplicate tags
//             if ($tagsContainer.find(`[data-value="${value}"]`).length) return;

//             const $tag = $(`
//                 <div class="enhanced-select-tag" data-value="${value}">
//                     ${text}
//                     <span class="enhanced-select-tag-remove">×</span>
//                 </div>
//             `);

//             $tagsContainer.append($tag);
//             $select.find(`option[value="${value}"]`).prop('selected', true);
//             $select.trigger('change');
//         }

//         // Initial population of tags
//         $select.find('option:selected').each(function() {
//             addTag($(this).text(), $(this).val());
//         });

//         // Input events
//         $input.on('input', function() {
//             populateDropdown($(this).val());
//         }).on('focus', function() {
//             populateDropdown($(this).val());
//         });

//         // Dropdown selection
//         $dropdown.on('click', '.enhanced-select-option', function() {
//             const value = $(this).data('value');
//             const text = $(this).text();
//             addTag(text, value);
//             $input.val('');
//             populateDropdown();
//         });

//         // Tag removal
//         $tagsContainer.on('click', '.enhanced-select-tag-remove', function() {
//             const $tag = $(this).parent();
//             const value = $tag.data('value');
            
//             $tag.remove();
//             $select.find(`option[value="${value}"]`).prop('selected', false);
//             $select.trigger('change');
//         });

//         // Close dropdown when clicking outside
//         $(document).on('click', function(e) {
//             if (!$container.is(e.target) && $container.has(e.target).length === 0) {
//                 $dropdown.hide();
//             }
//         });
//     }

//     // Initialize on page 4
//     function initializeEnhancedSelect() {
//         const $statesField = $('#field_3ktv4');
//         if ($statesField.length) {
//             // Use a slightly delayed initialization to avoid potential conflicts
//             setTimeout(function() {
//                 enhanceMultiSelect($statesField);
//             }, 500);
//         }
//     }

//     // Inject styles
//     injectStyles();

//     // Multiple initialization attempts
//     function setupEnhancedSelect() {
//         // Check if on page 4
//         if ($('.frm_page_4').length) {
//             initializeEnhancedSelect();
//         }
//     }

//     // Initialize on document ready
//     setupEnhancedSelect();

//     // Handle page changes with multiple methods
//     $(document).on('frmPageChanged', function(e, pageIndex) {
//         if (pageIndex === 3) { // Page 4 (zero-based)
//             setupEnhancedSelect();
//         }
//     });

//     // Additional fallback methods
//     $(window).on('load', setupEnhancedSelect);
    
//     // Periodic check for the select field
//     const selectCheckInterval = setInterval(function() {
//         const $statesField = $('#field_3ktv4');
//         if ($statesField.length && !$statesField.data('enhanced')) {
//             initializeEnhancedSelect();
//         }
//     }, 1000);

//     // Cleanup interval on unload
//     $(window).on('unload', function() {
//         clearInterval(selectCheckInterval);
//     });
// });


jQuery(document).ready(function ($) {
    // Inject styles for the enhanced select
    function injectStyles() {
        const styles = `
            .enhanced-select-container {
                position: relative;
                width: 100%;
            }
            .enhanced-select-input {
                width: 100%;
                padding: 8px 12px;
                border: 1px solid #ddd;
                border-radius: 4px;
                font-size: 14px;
            }
            .enhanced-select-tags {
                display: flex;
                flex-wrap: wrap;
                gap: 8px;
                margin-top: 8px;
            }
            .enhanced-select-tag {
                display: inline-flex;
                align-items: center;
                background: #f0f0f0;
                border-radius: 4px;
                padding: 6px 10px;
                font-size: 14px;
            }
            .enhanced-select-tag-remove {
                margin-left: 8px;
                cursor: pointer;
                color: #dc3545;
                font-weight: bold;
            }
            .enhanced-select-dropdown {
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: white;
                border: 1px solid #ddd;
                border-radius: 4px;
                max-height: 200px;
                overflow-y: auto;
                z-index: 1000;
                display: none;
            }
            .enhanced-select-option {
                padding: 8px 12px;
                cursor: pointer;
                font-size: 14px;
            }
            .enhanced-select-option:hover {
                background: #f0f0f0;
            }
        `;
        $('<style>').text(styles).appendTo('head');
    }

    // Enhanced select function
    function enhanceMultiSelect(selectElement) {
        const $select = $(selectElement);
        
        // Prevent re-initialization
        if ($select.data('enhanced')) return;
        $select.data('enhanced', true);

        // Create enhanced select container
        const $container = $('<div class="enhanced-select-container"></div>');
        const $input = $('<input type="text" class="enhanced-select-input" placeholder="Search and add states">');
        const $tagsContainer = $('<div class="enhanced-select-tags"></div>');
        const $dropdown = $('<div class="enhanced-select-dropdown"></div>');

        // Wrap the original select
        $select.hide().after($container);
        $container.append($input, $tagsContainer, $dropdown);

        // Populate dropdown
        function populateDropdown(searchTerm = '') {
            $dropdown.empty();
            $select.find('option').each(function() {
                const $option = $(this);
                const text = $option.text();
                const value = $option.val();

                // Skip if already selected or doesn't match search
                if ($option.prop('selected') || 
                    (searchTerm && !text.toLowerCase().includes(searchTerm.toLowerCase()))) {
                    return;
                }

                const $dropdownOption = $(`
                    <div class="enhanced-select-option" 
                         data-value="${value}">
                        ${text}
                    </div>
                `);
                $dropdown.append($dropdownOption);
            });

            $dropdown.toggle($dropdown.children().length > 0);
        }

        // Add tag function
        function addTag(text, value) {
            // Prevent duplicate tags
            if ($tagsContainer.find(`[data-value="${value}"]`).length) return;

            const $tag = $(`
                <div class="enhanced-select-tag" data-value="${value}">
                    ${text}
                    <span class="enhanced-select-tag-remove">×</span>
                </div>
            `);

            $tagsContainer.append($tag);
            $select.find(`option[value="${value}"]`).prop('selected', true);
            $select.trigger('change');
        }

        // Initial population of tags
        $select.find('option:selected').each(function() {
            addTag($(this).text(), $(this).val());
        });

        // Input events
        $input.on('input', function() {
            populateDropdown($(this).val());
        }).on('focus', function() {
            populateDropdown($(this).val());
        });

        // Dropdown selection
        $dropdown.on('click', '.enhanced-select-option', function() {
            const value = $(this).data('value');
            const text = $(this).text();
            addTag(text, value);
            $input.val('');
            populateDropdown();
        });

        // Tag removal
        $tagsContainer.on('click', '.enhanced-select-tag-remove', function() {
            const $tag = $(this).parent();
            const value = $tag.data('value');
            
            $tag.remove();
            $select.find(`option[value="${value}"]`).prop('selected', false);
            $select.trigger('change');
        });

        // Close dropdown when clicking outside
        $(document).on('click', function(e) {
            if (!$container.is(e.target) && $container.has(e.target).length === 0) {
                $dropdown.hide();
            }
        });
    }

    // Function to check and initialize enhanced select
    function checkAndInitializeEnhancedSelect() {
        const $statesField = $('#field_3ktv4');
        if ($statesField.length) {
            // Check if on the correct page (page 4)
            const currentPage = $('.frm_page_bar .frm_current_page').text() || 
                                new URLSearchParams(window.location.search).get('frm_page') || '1';
            
            if (currentPage === '4') {
                // Delayed initialization to ensure stepper is fully set up
                setTimeout(function() {
                    enhanceMultiSelect($statesField);
                }, 1000);  // Increased delay to 1 second
            }
        }
    }

    // Inject styles
    injectStyles();

    // Multiple initialization methods
    $(document).on('frmPageChanged', function(e, pageIndex) {
        if (pageIndex === 3) { // Page 4 (zero-based)
            checkAndInitializeEnhancedSelect();
        }
    });

    $(window).on('load', checkAndInitializeEnhancedSelect);

    // Periodic check for the select field
    const selectCheckInterval = setInterval(function() {
        const $statesField = $('#field_3ktv4');
        if ($statesField.length && !$statesField.data('enhanced')) {
            checkAndInitializeEnhancedSelect();
        }
    }, 1000);

    // Cleanup interval on unload
    $(window).on('unload', function() {
        clearInterval(selectCheckInterval);
    });
});</script>
<!-- end Simple Custom CSS and JS -->
