<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function ($) {
  // Function to handle visibility of the search field
  function handleSearchFieldVisibility() {
    // Target the specific field
    const searchField = $('#field_3ktv4');
    const activeStep = $('.form-step.active').index(); // Assumes class-based step system

    if (searchField.length > 0) {
      if (activeStep < 3) {
        searchField.hide(); // Hide the search input for steps 1 to 3
      } else {
        searchField.show(); // Show only when step 4 is reached
      }
    }
  }

  // Initial setup
  handleSearchFieldVisibility();

  // Event listener for step navigation
  $('.next-step-btn, .prev-step-btn').on('click', function () {
    setTimeout(handleSearchFieldVisibility, 300); // Delay for smooth form step transition
  });

  // Handle form step state when refreshing
  $(window).on('load', handleSearchFieldVisibility);
});
</script>
<!-- end Simple Custom CSS and JS -->
