<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
// jQuery(document).ready(function ($) {
//   // Target an existing element by its field ID and replace it
//   $("#frm_field_1943_container").replaceWith(`
//     <div class="color-picker-wrapper">
//       <input type="text" class="color-input" placeholder="e.g. #FFFFFF" id="colorValue">
//       <label for="colorPicker">
//         <span class="color-icon">💡</span> <!-- Lightbulb Icon -->
//       </label>
//       <input type="color" class="color-picker" id="colorPicker">
//     </div>
//   `);

//   const colorInput = $('#colorValue');
//   const colorPicker = $('#colorPicker');

//   $('.color-icon').on('click', function () {
//     colorPicker.trigger('click');
//   });

//   colorPicker.on('input', function () {
//     colorInput.val(colorPicker.val().toUpperCase());
//   });
// });




// jQuery(document).ready(function ($) {
//   // Target an existing element by its field ID and replace it
//   $("#frm_field_1943_container").replaceWith(
//     `<div class="color-picker-wrapper">
//       <input type="text" class="color-input" placeholder="e.g. #FFFFFF" id="colorValue">
//       <label for="colorPicker">
//         <span class="color-icon">
//           <img src="https://onboarding.enwage.com/wp-content/uploads/2025/02/eye.svg" alt="Color Picker Icon" />
//         </span>
//       </label>
//       <input type="color" class="color-picker" id="colorPicker">
//     </div>`
//   );

//   const colorInput = $('#colorValue');
//   const colorPicker = $('#colorPicker');

//   $('.color-icon').on('click', function () {
//     colorPicker.trigger('click');
//   });

//   colorPicker.on('input', function () {
//     colorInput.val(colorPicker.val().toUpperCase());
//   });
// });



// jQuery(document).ready(function ($) {
//   // Define a function to replace the content of field containers
//   function replaceFieldContent(fieldId) {
//     // Generate unique IDs for each field
//     const colorValueId = fieldId + "_colorValue";
//     const colorPickerId = fieldId + "_colorPicker";

//     $("#" + fieldId).replaceWith(
//       `<div class="color-picker-wrapper">
//         <input type="text" class="color-input" placeholder="e.g. #FFFFFF" id="${colorValueId}">
//         <label for="${colorPickerId}">
//           <span class="color-icon">
//             <img src="https://onboarding.enwage.com/wp-content/uploads/2025/02/eye.svg" alt="Color Picker Icon" />
//           </span>
//         </label>
//         <input type="color" class="color-picker" id="${colorPickerId}">
//       </div>`
//     );

//     const colorInput = $('#' + colorValueId);
//     const colorPicker = $('#' + colorPickerId);

//     // Handle click on color icon to trigger color picker
//     $('.color-icon').on('click', function () {
//       colorPicker.trigger('click');
//     });

//     // Update the text input value when color picker value changes
//     colorPicker.on('input', function () {
//       colorInput.val(colorPicker.val().toUpperCase());
//     });
//   }

  
//   // Replace content for two fields (you can add more fields by passing their IDs)
//   replaceFieldContent("frm_field_1943_container");
//   replaceFieldContent("frm_field_1942_container"); 
// });





// jQuery(document).ready(function ($) {
//   // Define a function to replace the content of field containers
//   function replaceFieldContent(fieldId) {
//     const colorValueId = fieldId + "_colorValue";
//     const colorPickerId = fieldId + "_colorPicker";
//     const originalField = $("#" + fieldId).find('input');
    
//     // Only replace if not already converted
//     if (!$("#" + fieldId).find('.color-picker-wrapper').length) {
//       // Store the original input's value
//       const originalValue = originalField.val() || '#FFFFFF'; // Default to white if no value
//       const originalName = originalField.attr('name'); // Get the original input's name
      
//       $("#" + fieldId).replaceWith(
//         `<div id="${fieldId}" class="color-picker-wrapper-container">
//           <div class="color-picker-wrapper">
//             <input type="text" class="color-input frm_form_field" 
//               name="${originalName}" 
//               placeholder="e.g. #FFFFFF" 
//               id="${colorValueId}" 
//               value="${originalValue}">
//             <label for="${colorPickerId}">
//               <span class="color-icon">
//                 <img src="https://onboarding.enwage.com/wp-content/uploads/2025/02/eye.svg" alt="Color Picker Icon" />
//               </span>
//             </label>
//             <input type="color" class="color-picker" id="${colorPickerId}" value="${originalValue}">
//           </div>
//         </div>`
//       );
      
//       const colorInput = $('#' + colorValueId);
//       const colorPicker = $('#' + colorPickerId);

//       // Handle click on color icon to trigger color picker
//       $('#' + fieldId).find('.color-icon').on('click', function () {
//         colorPicker.trigger('click');
//       });

//       // Update visible input when color picker changes
//       colorPicker.on('input', function () {
//         const newValue = $(this).val().toUpperCase();
//         colorInput.val(newValue);
//         // Trigger change event for Formidable Forms
//         colorInput.trigger('change');
//       });

//       // Update color picker when text input changes
//       colorInput.on('input', function () {
//         const newValue = $(this).val().toUpperCase();
//         colorPicker.val(newValue);
//         // Trigger change event for Formidable Forms
//         $(this).trigger('change');
//       });
//     }
//   }

//   // Function to initialize or reinitialize color pickers
//   function initializeColorPickers() {
//     replaceFieldContent("frm_field_1943_container");
//     replaceFieldContent("frm_field_1942_container");
//   }

//   // Initial setup
//   initializeColorPickers();

//   // Re-initialize after form submission
//   $(document).on('frmFormComplete', function() {
//     setTimeout(initializeColorPickers, 100); // Small delay to ensure form is updated
//   });

//   // Re-initialize on page change
//   $(document).on('frmPageChanged', function() {
//     setTimeout(initializeColorPickers, 100); // Small delay to ensure form is updated
//   });
  
//   // Handle AJAX completions
//   $(document).ajaxComplete(function(event, xhr, settings) {
//     if (settings.url && settings.url.includes('formidable')) {
//       setTimeout(initializeColorPickers, 100); // Small delay to ensure form is updated
//     }
//   });
// });





jQuery(document).ready(function ($) {
  // Define a function to replace the content of field containers
  function replaceFieldContent(fieldId) {
    const colorValueId = fieldId + "_colorValue";
    const colorPickerId = fieldId + "_colorPicker";
    const originalField = $("#" + fieldId).find('input');
    
    // Only replace if not already converted
    if (!$("#" + fieldId).find('.color-picker-wrapper').length) {
      // Store the original input's value without default
      const originalValue = originalField.val() || '';
      const originalName = originalField.attr('name'); // Get the original input's name
      
      $("#" + fieldId).replaceWith(
        `<div id="${fieldId}" class="color-picker-wrapper-container">
          <div class="color-picker-wrapper">
            <input type="text" class="color-input frm_form_field" 
              name="${originalName}" 
              placeholder="e.g. #FFFFFF" 
              id="${colorValueId}" 
              value="${originalValue}">
            <label for="${colorPickerId}">
              <span class="color-icon">
                <img src="https://onboarding.enwage.com/wp-content/uploads/2025/02/eye.svg" alt="Color Picker Icon" />
              </span>
            </label>
            <input type="color" class="color-picker" id="${colorPickerId}" 
              value="${originalValue || '#000000'}" 
              ${!originalValue ? 'data-no-color="true"' : ''}>
          </div>
        </div>`
      );
      
      const colorInput = $('#' + colorValueId);
      const colorPicker = $('#' + colorPickerId);

      // Handle click on color icon to trigger color picker
      $('#' + fieldId).find('.color-icon').on('click', function () {
        colorPicker.trigger('click');
      });

      // Update visible input when color picker changes
      colorPicker.on('input', function () {
        const newValue = $(this).val().toUpperCase();
        colorInput.val(newValue);
        $(this).removeAttr('data-no-color');
        // Trigger change event for Formidable Forms
        colorInput.trigger('change');
      });

      // Update color picker when text input changes
      colorInput.on('input', function () {
        let newValue = $(this).val().toUpperCase();
        
        // If input is cleared, reset the color picker
        if (!newValue) {
          colorPicker.attr('data-no-color', 'true');
          colorPicker.val('#000000'); // Set to black but don't show it
        } else {
          colorPicker.removeAttr('data-no-color');
          colorPicker.val(newValue);
        }
        
        // Trigger change event for Formidable Forms
        $(this).trigger('change');
      });

      // Add backspace/delete handling for the text input
      colorInput.on('keyup', function(e) {
        if (e.key === 'Backspace' || e.key === 'Delete') {
          if (!$(this).val()) {
            colorPicker.attr('data-no-color', 'true');
            colorPicker.val('#000000');
          }
        }
      });
    }
  }

  // Function to initialize or reinitialize color pickers
  function initializeColorPickers() {
    replaceFieldContent("frm_field_1943_container");
    replaceFieldContent("frm_field_1942_container");
  }

  // Initial setup
  initializeColorPickers();

  // Re-initialize after form submission
  $(document).on('frmFormComplete', function() {
    setTimeout(initializeColorPickers, 100);
  });

  // Re-initialize on page change
  $(document).on('frmPageChanged', function() {
    setTimeout(initializeColorPickers, 100);
  });
  
  // Handle AJAX completions
  $(document).ajaxComplete(function(event, xhr, settings) {
    if (settings.url && settings.url.includes('formidable')) {
      setTimeout(initializeColorPickers, 100);
    }
  });

  // Add CSS to handle the no-color state
  const style = `
    <style>
      .color-picker[data-no-color="true"] {
        background-color: transparent !important;
      }
    </style>
  `;
  $('head').append(style);
});








</script>
<!-- end Simple Custom CSS and JS -->
