<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );
         
if ( !function_exists( 'child_theme_configurator_css' ) ):
    function child_theme_configurator_css() {
        wp_enqueue_style( 'chld_thm_cfg_child', trailingslashit( get_stylesheet_directory_uri() ) . 'style.css', array( 'hello-elementor','hello-elementor','hello-elementor-theme-style','hello-elementor-header-footer' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'child_theme_configurator_css', 10 );

// END ENQUEUE PARENT ACTION

function custom_sidebar_menu_shortcode() {
    ob_start();
    ?>
    <div id="custom-sidebar-menu">
        <div class="sidebar">
            <ul class="sidebar-menu">
                <li><a href="#" class="menu-item" data-target="tab1">Overview</a></li>
                <li><a href="#" class="menu-item" data-target="tab2">Company Setup</a></li>
                <li><a href="#" class="menu-item" data-target="tab3">Integrations</a></li>
            </ul>
        </div>
        <div id="tab-content">
            <div id="tab1" class="tab-pane"><?php echo do_shortcode('[display-frm-data id=425 drafts="both"]'); ?></div>
            <div id="tab2" class="tab-pane" style="display: none;"><?php echo do_shortcode('[formidable id=46]'); ?></div>
            <div id="tab3" class="tab-pane" style="display: none;"><?php echo do_shortcode('[your_shortcode_3]'); ?></div>
        </div>
    </div>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const menuItems = document.querySelectorAll(".menu-item");
            const tabPanes = document.querySelectorAll(".tab-pane");

            menuItems.forEach(item => {
                item.addEventListener("click", function (e) {
                    e.preventDefault();
                    const target = this.getAttribute("data-target");

                    // Hide all tab panes
                    tabPanes.forEach(pane => pane.style.display = "none");

                    // Show the target tab pane
                    document.getElementById(target).style.display = "block";
                });
            });
        });
    </script>
    <style>
        #custom-sidebar-menu {
            display: flex;
        }
        .sidebar {
            position: sticky;
            top: 0;
            height: 100vh;
            overflow-y: auto;
            width: 200px;
            border-right: 1px solid #ddd;
            background-color: #f9f9f9;
        }
        .sidebar-menu {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar-menu li {
            margin: 0;
            padding: 10px;
        }
        .sidebar-menu a {
            text-decoration: none;
            color: #000;
            display: block;
        }
        .sidebar-menu a:hover {
            color: #0073aa;
        }
        .tab-pane {
            padding: 20px;
            flex-grow: 1;
        }
    </style>
    <?php
    return ob_get_clean();
}
add_shortcode('custom_sidebar_menu', 'custom_sidebar_menu_shortcode');

//color picker
function frm_default_custom_scripts( $scripts ){
	$scripts->add( 'iris', '/wp-admin/js/iris.min.js', array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ), '1.1.1', 1 );
	$scripts->add( 'wp-color-picker', "/wp-admin/js/color-picker.js", array( 'iris' ), false, 1 );
	$scripts->set_translations( 'wp-color-picker' );
	$custom_css = '.frm-color-picker .button.wp-color-result{border-radius: var(--border-radius) !important}' .
		'.frm-color-picker .wp-picker-container{position:relative}' .
		'.frm-color-picker .wp-picker-clear, .frm-color-picker .screen-reader-text{display:none !important}' .
		'.with_frm_style .frm-color-picker input{position:absolute;width:90px !important;left:32px;border:none;top:1px}';
	wp_add_inline_style( 'wp-color-picker', $custom_css );
}
add_action( 'wp_default_scripts', 'frm_default_custom_scripts' );

function frm_add_colorpicker() {
	wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_script( 'wp-color-picker' );
?>
jQuery(document).ready(function($){
$('.frm-color-picker input').wpColorPicker();
});
<?php
}
add_action( 'frm_entries_footer_scripts', 'frm_add_colorpicker' );



// Register a shortcode for the user profile
function user_profile_shortcode() {
    // Fetch the current user
    $current_user = wp_get_current_user();
    
    // Check if user exists
    if ($current_user->exists()) {
        $user_name = $current_user->display_name; // Get user name
        $user_email = $current_user->user_email; // Get user email
        $user_avatar = get_avatar_url($current_user->ID, array('size' => 120)); // Get user avatar
    } else {
        // Default fallback values
        $user_name = 'Guest';
        $user_email = 'guest@example.com';
        $user_avatar = 'https://example.com/default-avatar.png'; // Replace with your default image URL
    }

    // Return the HTML structure
    return '
    <div class="profile-section">
        <div class="profile-header">
            <img src="' . esc_url($user_avatar) . '" alt="Profile" class="profile-image">
            <div class="profile-name">' . esc_html($user_name) . '</div>
            <div class="profile-email">' . esc_html($user_email) . '</div>
        </div>
    </div>';
}
add_shortcode('user_profile', 'user_profile_shortcode');

// For logout button
function custom_logout_button_shortcode() {
    $logout_url = wp_logout_url();
    ob_start();
    ?>
    <div class="logout-container">
        <a href="<?php echo esc_url($logout_url); ?>" class="logout-link">
            <span class="logout-text">Logout</span>
            <span class="logout-icon">
                <i class="fa-regular fa-right-from-bracket"></i>
            </span>
        </a>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('logout_button', 'custom_logout_button_shortcode');
