<?php
/*
Plugin Name: Role-Based Email Templates
Description: Sends customized HTML email templates for user registration and password reset based on roles.
Version: 1.1
Author: Ammar
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Customize new user registration email based on user role.
 */
add_filter('wp_new_user_notification_email', function($email, $user, $blogname) {
    if (!$user instanceof WP_User) {
        return $email; // Return default email if $user is invalid.
    }

    $user_role = $user->roles[0] ?? ''; // Get the user's primary role.

    // Define HTML templates for new user email.
    $templates = [
        'contributor' => "
        <!DOCTYPE html>
        <html>
        <head><title>Welcome, Contributor!</title></head>
        <body>
            <h1>Welcome, Contributor!</h1>
            <p>Hello {$user->display_name},</p>
            <p>Your account has been created successfully. You can log in using the following details:</p>
            <p><strong>Username:</strong> {$user->user_login}</p>
            <p>Enjoy your time with us!</p>
        </body>
        </html>
        ",
        'editor' => "
        <!DOCTYPE html>
        <html>
        <head><title>Welcome, Editor!</title></head>
        <body>
            <h1>Welcome, Editor!</h1>
            <p>Hello {$user->display_name},</p>
            <p>Your account has been created successfully. You can log in using the following details:</p>
            <p><strong>Username:</strong> {$user->user_login}</p>
            <p>Thank you for joining us!</p>
        </body>
        </html>
        ",
    ];

    // Apply the appropriate template based on the user's role.
    if (isset($templates[$user_role])) {
        $email['subject'] = "Welcome to {$blogname}, {$user->display_name}!";
        $email['message'] = $templates[$user_role];
    }

    return $email;
}, 10, 3);

/**
 * Customize password reset email based on user role.
 */
add_filter('retrieve_password_message', function($message, $key, $user_login, $user_data) {
    if (!$user_data instanceof WP_User) {
        return $message; // Return default message if $user_data is invalid.
    }

    $user_role = $user_data->roles[0] ?? ''; // Get the user's primary role.

    // Define HTML templates for password reset email.
    $templates = [
        'contributor' => "
        <!DOCTYPE html>
        <html>
        <head><title>Password Reset Request</title></head>
        <body>
            <h1>Password Reset Request</h1>
            <p>Hello {$user_data->display_name},</p>
            <p>You requested a password reset. Click the link below to reset your password:</p>
            <p><a href='" . wp_lostpassword_url() . "?key={$key}&login={$user_login}'>Reset Password</a></p>
            <p>If you didn't request this, please ignore this email.</p>
        </body>
        </html>
        ",
        'editor' => "
        <!DOCTYPE html>
        <html>
        <head><title>Password Reset Request</title></head>
        <body>
            <h1>Password Reset Request</h1>
            <p>Hello {$user_data->display_name},</p>
            <p>You requested a password reset. Click the link below to reset your password:</p>
            <p><a href='" . wp_lostpassword_url() . "?key={$key}&login={$user_login}'>Reset Password</a></p>
            <p>If you didn't request this, please ignore this email.</p>
        </body>
        </html>
        ",
    ];

    // Apply the appropriate template based on the user's role.
    if (isset($templates[$user_role])) {
        return $templates[$user_role];
    }

    return $message; // Return default message if no template is found.
}, 10, 4);

?>
