( function( $ ) {
	'use strict';

	const __ = wp.i18n.__;

	const FrmQuizzesGradingScale = {
		init: function() {
			const self = this;
			$( 'body' ).on( 'click', '.grading-scale-row .frm_add_tag', function( el ) {
				el.preventDefault();
				self.addRow();
			});

			document.querySelectorAll( '.grading-scale-row .frm_remove_tag' ).forEach( el => {
				el.addEventListener( 'click', self.resetKeys );
			});
		},
		getNewGradingRowID: function() {
			const lastGradingScaleRowID = document.querySelector( '.grading-scale-row:last-of-type' ).id;
			const lastRowIndex = parseInt( lastGradingScaleRowID.split( '-' ).pop() ) + 1;
			return 'grading-scale-row-' + lastRowIndex;
		},
		addRow: function() {
			const self = this;
			const gradingScaleRows = document.querySelector( '.grading-scale-rows' );
			const key = gradingScaleRows.childElementCount; //Starts at 1
			const newRowID = self.getNewGradingRowID();
			let newRowHtml = '<div id="' + newRowID + '" class="grading-scale-row">';
			newRowHtml += '<input class="small-text grade" type="text" name="frm_quizzes_grading_scale[' + key + '][grade]" />';
			newRowHtml += '<input class="small-text start" type="text" name="frm_quizzes_grading_scale[' + key + '][start]" />';
			newRowHtml += '<input class="small-text end" type="text" name="frm_quizzes_grading_scale[' + key + '][end]" />';
			newRowHtml += '<a href="#" class="frm_add_form_row frm_add_tag frm_icon_font " aria-label="' + __( 'Add', 'formidable-quizzes' ) + '"></a>';
			newRowHtml += '<a href="#" data-removeid="' + newRowID + '" class="frm_remove_form_row frm_remove_tag frm_icon_font " aria-label="' + __( 'Remove', 'formidable-quizzes' ) + '"></a>';
			newRowHtml += '</div>';
			gradingScaleRows.insertAdjacentHTML( 'beforeend', newRowHtml );
			gradingScaleRows.lastElementChild.addEventListener( 'click', self.resetKeys );
		},
		resetKeys: function() {
			setTimeout( function() {
				$( '.grading-scale-rows .grading-scale-row' ).each( function( index ) {
					$( this ).find( 'input.grade' ).attr( 'name', 'frm_quizzes_grading_scale[' + index + '][grade]' );
					$( this ).find( 'input.start' ).attr( 'name', 'frm_quizzes_grading_scale[' + index + '][start]' );
					$( this ).find( 'input.end' ).attr( 'name', 'frm_quizzes_grading_scale[' + index + '][end]' );
				});
			}, 600 ); // delay a bit until the current row is removed before resetting input names.
		}
	};

	$( function() {
		FrmQuizzesGradingScale.init();
	});
}( jQuery ) );
